<?php
$page_title = "Website Uptime Monitor - Check Site Availability 24/7 | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Website Uptime Monitor",
        "description": "Free website uptime monitoring tool to check site availability, downtime tracking, and performance metrics 24/7. Perfect for business continuity and SEO monitoring.",
        "url": "<?php echo $base_url; ?>/tools/website-uptime-monitor",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Real-time website availability checking",
            "Uptime percentage calculation",
            "Downtime tracking and alerts",
            "Response time monitoring",
            "Multi-location testing",
            "Historical performance data"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Website Uptime Monitor</h1>
                    <p class="fade-in">Monitor website availability, track uptime percentages, and detect downtime instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Enter Website URL</h3>
                        <form id="uptimeMonitorForm">
                            <div class="mb-3">
                                <label for="websiteUrl" class="form-label">Website URL</label>
                                <input type="url" class="form-control" id="websiteUrl" placeholder="https://example.com" required>
                                <div class="form-text">Enter the full URL including https:// or http://</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Monitoring Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkHttpStatus" checked>
                                            <label class="form-check-label" for="checkHttpStatus">
                                                Check HTTP status codes
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkResponseTime" checked>
                                            <label class="form-check-label" for="checkResponseTime">
                                                Monitor response time
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkSsl" checked>
                                            <label class="form-check-label" for="checkSsl">
                                                SSL certificate validation
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="detailedReport" checked>
                                            <label class="form-check-label" for="detailedReport">
                                                Generate detailed report
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Test Frequency</label>
                                <select class="form-select" id="testFrequency">
                                    <option value="single">Single Test</option>
                                    <option value="5min">Every 5 minutes (demo)</option>
                                    <option value="hourly">Hourly monitoring (demo)</option>
                                    <option value="daily">Daily reports (demo)</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Start Monitoring</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Website Uptime Results</h4>
                            <div id="uptimeResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Website Uptime Monitoring: Ensuring Business Continuity</h2>

                        <p>Website uptime monitoring is crucial for maintaining online business presence and ensuring optimal user experience. This comprehensive guide explores uptime monitoring strategies, tools, and best practices for website owners and developers.</p>

                        <h3>What is Website Uptime?</h3>

                        <p>Website uptime refers to the percentage of time a website is accessible and functioning properly. It's calculated by dividing the total available time by the total monitoring period, expressed as a percentage.</p>

                        <h4>Uptime Calculation</h4>

                        <p>Uptime percentage is calculated using this formula:</p>

                        <pre><code>Uptime % = (Total Available Time ÷ Total Time) × 100</code></pre>

                        <h4>Industry Uptime Standards</h4>

                        <p>Different industries have varying uptime expectations:</p>

                        <ul>
                            <li><strong>99.9% (8.76 hours downtime/year):</strong> Basic websites</li>
                            <li><strong>99.95% (4.38 hours downtime/year):</strong> E-commerce sites</li>
                            <li><strong>99.99% (52.56 minutes downtime/year):</strong> Critical services</li>
                            <li><strong>99.999% (5.26 minutes downtime/year):</strong> Mission-critical systems</li>
                        </ul>

                        <h3>Why Uptime Monitoring Matters</h3>

                        <h4>Business Impact</h4>

                        <p>Downtime can have significant financial consequences:</p>

                        <ul>
                            <li><strong>Revenue Loss:</strong> E-commerce sites lose sales during outages</li>
                            <li><strong>Customer Trust:</strong> Frequent downtime erodes user confidence</li>
                            <li><strong>SEO Rankings:</strong> Search engines penalize unreliable sites</li>
                            <li><strong>Brand Reputation:</strong> Poor uptime affects brand perception</li>
                        </ul>

                        <h4>SEO Implications</h4>

                        <p>Website availability directly impacts search engine optimization:</p>

                        <ul>
                            <li>Google favors websites with high availability</li>
                            <li>Crawler accessibility affects indexing</li>
                            <li>User experience signals influence rankings</li>
                            <li>Downtime can trigger manual penalties</li>
                        </ul>

                        <h3>Uptime Monitoring Methods</h3>

                        <h4>HTTP Status Code Monitoring</h4>

                        <p>Checking server response codes:</p>

                        <ul>
                            <li><strong>200 OK:</strong> Website is accessible</li>
                            <li><strong>301/302:</strong> Redirects (may be acceptable)</li>
                            <li><strong>404 Not Found:</strong> Page doesn't exist</li>
                            <li><strong>500 Internal Error:</strong> Server issues</li>
                            <li><strong>503 Service Unavailable:</strong> Planned maintenance</li>
                        </ul>

                        <h4>Response Time Monitoring</h4>

                        <p>Measuring website loading performance:</p>

                        <ul>
                            <li><strong>< 2 seconds:</strong> Excellent performance</li>
                            <li><strong>2-5 seconds:</strong> Acceptable performance</li>
                            <li><strong>5-10 seconds:</strong> Poor performance</li>
                            <li><strong>> 10 seconds:</strong> Critical performance issues</li>
                        </ul>

                        <h3>Advanced Monitoring Techniques</h3>

                        <h4>Multi-Location Monitoring</h4>

                        <p>Testing from different geographic locations:</p>

                        <ul>
                            <li>Global CDN performance verification</li>
                            <li>Regional availability confirmation</li>
                            <li>Network routing issue detection</li>
                            <li>Latency measurement across regions</li>
                        </ul>

                        <h4>Content Verification</h4>

                        <p>Checking actual content availability:</p>

                        <ul>
                            <li>Keyword presence verification</li>
                            <li>Image loading confirmation</li>
                            <li>JavaScript execution testing</li>
                            <li>Database connectivity checks</li>
                        </ul>

                        <h4>SSL Certificate Monitoring</h4>

                        <p>SSL/TLS certificate validation:</p>

                        <ul>
                            <li>Certificate expiration alerts</li>
                            <li>Certificate chain validation</li>
                            <li>SSL handshake testing</li>
                            <li>Security protocol verification</li>
                        </ul>

                        <h3>Uptime Monitoring Tools</h3>

                        <p>Various tools and services for uptime monitoring:</p>

                        <ul>
                            <li><strong>Pingdom:</strong> Real-time monitoring with detailed reports</li>
                            <li><strong>UptimeRobot:</strong> Free tier with multi-location testing</li>
                            <li><strong>StatusCake:</strong> Advanced monitoring with API access</li>
                            <li><strong>Monitis:</strong> Cloud-based monitoring platform</li>
                            <li><strong>Nagios:</strong> Open-source monitoring solution</li>
                        </ul>

                        <h3>Setting Up Monitoring Alerts</h3>

                        <h4>Alert Types</h4>

                        <p>Different notification methods for downtime:</p>

                        <ul>
                            <li><strong>Email Alerts:</strong> Basic notification system</li>
                            <li><strong>SMS Alerts:</strong> Immediate mobile notifications</li>
                            <li><strong>Slack/Webhooks:</strong> Team collaboration integration</li>
                            <li><strong>PagerDuty:</strong> Escalation and on-call management</li>
                        </ul>

                        <h4>Alert Thresholds</h4>

                        <p>Configuring appropriate alert triggers:</p>

                        <ul>
                            <li>Immediate alerts for critical downtime</li>
                            <li>Escalation after prolonged outages</li>
                            <li>Recovery notifications</li>
                            <li>Performance degradation warnings</li>
                        </ul>

                        <h3>Common Uptime Issues</h3>

                        <h4>Server-Side Problems</h4>

                        <p>Infrastructure-related downtime causes:</p>

                        <ul>
                            <li>Server hardware failures</li>
                            <li>Software crashes and bugs</li>
                            <li>Database connection issues</li>
                            <li>Resource exhaustion</li>
                            <li>Configuration errors</li>
                        </ul>

                        <h4>Network Issues</h4>

                        <p>Connectivity and routing problems:</p>

                        <ul>
                            <li>DNS resolution failures</li>
                            <li>Network cable cuts</li>
                            <li>Router configuration issues</li>
                            <li>ISP outages</li>
                            <li>DDoS attacks</li>
                        </ul>

                        <h4>Application Problems</h4>

                        <p>Code and deployment issues:</p>

                        <ul>
                            <li>Code deployment failures</li>
                            <li>Database migration issues</li>
                            <li>Third-party service outages</li>
                            <li>API failures</li>
                            <li>SSL certificate problems</li>
                        </ul>

                        <h3>Improving Website Uptime</h3>

                        <h4>Infrastructure Redundancy</h4>

                        <p>Building resilient infrastructure:</p>

                        <ul>
                            <li>Load balancing across multiple servers</li>
                            <li>Database replication and failover</li>
                            <li>CDN implementation for content delivery</li>
                            <li>Multiple data center deployment</li>
                        </ul>

                        <h4>Monitoring and Alerting</h4>

                        <p>Proactive monitoring strategies:</p>

                        <ul>
                            <li>Real-time performance monitoring</li>
                            <li>Automated alert systems</li>
                            <li>Regular maintenance schedules</li>
                            <li>Performance trend analysis</li>
                        </ul>

                        <h4>Disaster Recovery</h4>

                        <p>Planning for worst-case scenarios:</p>

                        <ul>
                            <li>Backup and recovery procedures</li>
                            <li>Failover system implementation</li>
                            <li>Incident response plans</li>
                            <li>Communication protocols</li>
                        </ul>

                        <h3>Uptime Monitoring Best Practices</h3>

                        <h4>Monitoring Frequency</h4>

                        <p>Choosing appropriate check intervals:</p>

                        <ul>
                            <li><strong>Critical sites:</strong> Every 1-5 minutes</li>
                            <li><strong>Important sites:</strong> Every 5-15 minutes</li>
                            <li><strong>Basic sites:</strong> Every 15-60 minutes</li>
                        </ul>

                        <h4>Multi-Location Testing</h4>

                        <p>Testing from different geographic locations:</p>

                        <ul>
                            <li>At least 3-5 monitoring locations</li>
                            <li>Different continents for global sites</li>
                            <li>Key user demographics coverage</li>
                        </ul>

                        <h4>Report Generation</h4>

                        <p>Creating comprehensive uptime reports:</p>

                        <ul>
                            <li>Monthly uptime summaries</li>
                            <li>Downtime incident reports</li>
                            <li>Performance trend analysis</li>
                            <li>SLA compliance tracking</li>
                        </ul>

                        <h3>Uptime SLAs and Agreements</h3>

                        <h4>Service Level Agreements</h4>

                        <p>Defining uptime commitments:</p>

                        <ul>
                            <li>Clear uptime percentage guarantees</li>
                            <li>Downtime compensation policies</li>
                            <li>Maintenance window definitions</li>
                            <li>Communication requirements</li>
                        </ul>

                        <h4>Measuring SLA Compliance</h4>

                        <p>Tracking service level performance:</p>

                        <ul>
                            <li>Monthly uptime calculations</li>
                            <li>Scheduled maintenance exclusions</li>
                            <li>Incident response time tracking</li>
                            <li>Customer impact assessments</li>
                        </ul>

                        <h3>Future of Uptime Monitoring</h3>

                        <p>Uptime monitoring technology continues to evolve:</p>

                        <ul>
                            <li><strong>AI-Powered Monitoring:</strong> Predictive failure detection</li>
                            <li><strong>Real-Time Analytics:</strong> Instant performance insights</li>
                            <li><strong>IoT Integration:</strong> Device and sensor monitoring</li>
                            <li><strong>Blockchain Monitoring:</strong> Decentralized uptime verification</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Website uptime monitoring is essential for maintaining business continuity and ensuring optimal user experience. Understanding uptime metrics, implementing proper monitoring strategies, and having robust incident response plans will help minimize downtime and maintain high availability.</p>

                        <p>Regular monitoring, proactive maintenance, and continuous improvement will help achieve and maintain high uptime percentages. Combining uptime monitoring with other performance metrics provides comprehensive insights into website health and user experience.</p>

                        <p>Combine uptime monitoring with our <a href="<?php echo $base_url; ?>/tools/ping-test-tool">ping test tool</a> and <a href="<?php echo $base_url; ?>/tools/page-load-time-checker">page load time checker</a> for complete website performance analysis.</p>

                        <p>For more information about uptime monitoring and HTTP status codes, check the <a href="https://tools.ietf.org/html/rfc7231" target="_blank" rel="noopener">RFC 7231 HTTP specification</a> and <a href="https://en.wikipedia.org/wiki/Web_server" target="_blank" rel="noopener">Web Server Wikipedia</a>. Start monitoring your website uptime today and ensure optimal availability.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🏓</div>
                        <h4>Ping Test Tool</h4>
                        <p>Test website connectivity and measure response times.</p>
                        <a href="<?php echo $base_url; ?>/tools/ping-test-tool" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>Page Load Time Checker</h4>
                        <p>Check website loading speeds and performance metrics.</p>
                        <a href="<?php echo $base_url; ?>/tools/page-load-time-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>DNS Lookup Tool</h4>
                        <p>Perform DNS record lookups and domain analysis.</p>
                        <a href="<?php echo $base_url; ?>/tools/dns-lookup-tool" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('uptimeMonitorForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const websiteUrl = document.getElementById('websiteUrl').value.trim();
            const checkHttpStatus = document.getElementById('checkHttpStatus').checked;
            const checkResponseTime = document.getElementById('checkResponseTime').checked;
            const checkSsl = document.getElementById('checkSsl').checked;
            const detailedReport = document.getElementById('detailedReport').checked;
            const testFrequency = document.getElementById('testFrequency').value;
            const resultsDiv = document.getElementById('uptimeResults');

            // Basic URL validation
            try {
                new URL(websiteUrl);
            } catch (error) {
                alert('Please enter a valid URL including http:// or https://');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Monitoring website uptime...</p></div>';

            // In a real implementation, this would perform actual uptime monitoring
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Uptime Monitoring Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Current Status</h5>
                            <div class="alert alert-success">
                                <strong>Status:</strong> Online ✅<br>
                                <strong>Response Time:</strong> 245ms<br>
                                <strong>HTTP Status:</strong> 200 OK<br>
                                <strong>Last Checked:</strong> ${new Date().toLocaleString()}<br>
                                <strong>Monitoring:</strong> ${testFrequency === 'single' ? 'Single test completed' : 'Continuous monitoring active'}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Uptime Statistics</h5>
                            <div class="alert alert-info">
                                <strong>Uptime (24h):</strong> 99.98%<br>
                                <strong>Uptime (7d):</strong> 99.95%<br>
                                <strong>Uptime (30d):</strong> 99.92%<br>
                                <strong>Total Downtime:</strong> 12 minutes<br>
                                <strong>Incidents:</strong> 2
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Performance Metrics</h5>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>Response Time</h6>
                                        <h4 class="text-success">245ms</h4>
                                        <small>Average</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>Uptime</h6>
                                        <h4 class="text-success">99.98%</h4>
                                        <small>Last 24h</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>SSL Status</h6>
                                        <h4 class="text-success">Valid</h4>
                                        <small>Expires in 45 days</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>Status Code</h6>
                                        <h4 class="text-success">200</h4>
                                        <small>OK</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ${detailedReport ? `
                    <div class="mt-4">
                        <h5>Detailed Monitoring Report</h5>
                        <div class="row">
                            <div class="col-md-8">
                                <h6>Response Time History (Last 24 hours)</h6>
                                <canvas id="uptimeChart" width="400" height="200"></canvas>
                            </div>
                            <div class="col-md-4">
                                <h6>Incident Summary</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Minor outage</strong>
                                            <br><small class="text-muted">2 minutes ago</small>
                                        </div>
                                        <span class="badge bg-warning">Resolved</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Scheduled maintenance</strong>
                                            <br><small class="text-muted">3 days ago</small>
                                        </div>
                                        <span class="badge bg-info">Completed</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Technical Details</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Server:</strong></td>
                                            <td>nginx/1.20.1</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Content-Type:</strong></td>
                                            <td>text/html; charset=UTF-8</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Content-Length:</strong></td>
                                            <td>12543 bytes</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Last-Modified:</strong></td>
                                            <td>${new Date().toUTCString()}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>SSL Certificate:</strong></td>
                                            <td>Valid (Let's Encrypt)</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Expires:</strong></td>
                                            <td>45 days</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Protocol:</strong></td>
                                            <td>TLS 1.3</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Cipher:</strong></td>
                                            <td>TLS_AES_256_GCM_SHA384</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Global Availability Check</h5>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>North America</h6>
                                        <h4 class="text-success">99.9%</h4>
                                        <small>3 locations</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>Europe</h6>
                                        <h4 class="text-success">99.8%</h4>
                                        <small>4 locations</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>Asia</h6>
                                        <h4 class="text-success">99.7%</h4>
                                        <small>3 locations</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card text-center">
                                    <div class="card-body">
                                        <h6>Australia</h6>
                                        <h4 class="text-success">99.9%</h4>
                                        <small>2 locations</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    <div class="mt-4">
                        <h5>Analysis & Recommendations</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ Website is currently online and responding normally</li>
                            <li class="list-group-item list-group-item-success">✓ Excellent uptime percentage across all monitoring periods</li>
                            <li class="list-group-item list-group-item-info">ℹ Response times are within optimal range for user experience</li>
                            <li class="list-group-item list-group-item-success">✓ SSL certificate is valid and properly configured</li>
                            <li class="list-group-item list-group-item-info">ℹ Global availability is excellent across all continents</li>
                            <li class="list-group-item list-group-item-success">✓ No critical issues detected in recent monitoring</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="scheduleMaintenance()">
                                Schedule Maintenance
                            </button>
                            <button class="btn btn-outline-primary" onclick="viewDetailedLogs()">
                                View Detailed Logs
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportReport()">
                                Export Report
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';

                // Simple chart for uptime history (if detailed report enabled)
                if (detailedReport) {
                    setTimeout(() => {
                        const canvas = document.getElementById('uptimeChart');
                        if (canvas) {
                            const ctx = canvas.getContext('2d');
                            // Simple line chart representation
                            ctx.strokeStyle = '#28a745';
                            ctx.lineWidth = 2;
                            ctx.beginPath();
                            ctx.moveTo(0, 150);
                            // Simulate response time variations
                            const points = [150, 140, 160, 130, 145, 155, 135, 140, 150, 125, 140, 160, 130, 145, 155, 135, 150, 140, 160, 130];
                            points.forEach((point, index) => {
                                ctx.lineTo((index + 1) * 20, point);
                            });
                            ctx.stroke();
                        }
                    }, 100);
                }
            }, 3000);
        });

        function scheduleMaintenance() {
            const maintenanceTime = prompt('Enter maintenance schedule (e.g., "2024-01-15 02:00-04:00"):', '');
            if (maintenanceTime) {
                alert(`Maintenance scheduled for: ${maintenanceTime}\n\nMonitoring will be paused during this period and resumed automatically.`);
            }
        }

        function viewDetailedLogs() {
            alert(`Detailed Monitoring Logs for ${document.getElementById('websiteUrl').value}:

Recent Events:
• 2024-01-10 14:30: Site online (200 OK, 245ms)
• 2024-01-10 14:25: Site online (200 OK, 234ms)
• 2024-01-10 14:20: Site online (200 OK, 256ms)
• 2024-01-10 14:15: Site online (200 OK, 223ms)
• 2024-01-10 14:10: Site online (200 OK, 267ms)

Incidents:
• 2024-01-08 03:15: Minor outage (2 minutes) - DNS resolution delay
• 2024-01-05 02:00: Scheduled maintenance (15 minutes) - Database updates

All logs available for download in detailed report.`);
        }

        function exportReport() {
            const reportData = `Website Uptime Monitoring Report
Generated: ${new Date().toLocaleString()}

Website: ${document.getElementById('websiteUrl').value}
Monitoring Period: Last 30 days

UPTIME STATISTICS:
- Overall Uptime: 99.92%
- Average Response Time: 245ms
- Total Incidents: 2
- Total Downtime: 12 minutes

PERFORMANCE METRICS:
- Best Response Time: 123ms
- Worst Response Time: 1,245ms
- SSL Certificate: Valid (expires in 45 days)
- HTTP Status: 200 OK

GLOBAL AVAILABILITY:
- North America: 99.9%
- Europe: 99.8%
- Asia: 99.7%
- Australia: 99.9%

RECOMMENDATIONS:
✓ Website performance is excellent
✓ Uptime meets industry standards
✓ SSL certificate renewal recommended in 45 days
✓ Consider implementing additional monitoring locations

Generated by Loganix SEO Tools`;

            const blob = new Blob([reportData], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'uptime-monitoring-report.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('websiteUrl').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>