<?php
$page_title = "Text Case Converter - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Text Case Converter</h1>
                    <p class="fade-in">Convert text between different case formats for consistent styling and professional presentation.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Convert Text Case</h3>
                        <form id="textCaseForm">
                            <div class="mb-3">
                                <label for="inputText" class="form-label">Input Text</label>
                                <textarea class="form-control" id="inputText" rows="6" placeholder="Enter your text here to convert case..." required></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="caseType" class="form-label">Case Conversion Type</label>
                                <select class="form-control" id="caseType">
                                    <option value="uppercase">UPPERCASE</option>
                                    <option value="lowercase">lowercase</option>
                                    <option value="titlecase">Title Case</option>
                                    <option value="sentencecase">Sentence case</option>
                                    <option value="camelcase">camelCase</option>
                                    <option value="pascalcase">PascalCase</option>
                                    <option value="snakecase">snake_case</option>
                                    <option value="kebabcase">kebab-case</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="preserveAbbreviations">
                                    <label class="form-check-label" for="preserveAbbreviations">
                                        Preserve common abbreviations (e.g., USA, HTML, SEO)
                                    </label>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Convert Text</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Text Case Conversion Results</h4>
                            <div id="textCaseResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Text Case Conversion for Professional Content and SEO</h2>

                        <p>Text case conversion is essential for maintaining consistent formatting and professional presentation across digital content. A text case converter helps transform text between different case styles, ensuring proper capitalization for titles, headings, code, and various content types. This comprehensive guide explores text case conversion techniques, best practices, and applications for content creation and SEO.</p>

                        <h3>What is Text Case Conversion?</h3>

                        <p>Text case conversion involves changing the capitalization of text according to different formatting standards and style guidelines, ensuring consistency and readability across different contexts.</p>

                        <h4>Common Case Types</h4>

                        <ul>
                            <li><strong>Uppercase:</strong> ALL CAPS - used for emphasis and acronyms</li>
                            <li><strong>Lowercase:</strong> all lowercase - used for URLs and code</li>
                            <li><strong>Title Case:</strong> Capitalize First Letter Of Each Word</li>
                            <li><strong>Sentence Case:</strong> Capitalize first word of each sentence</li>
                            <li><strong>camelCase:</strong> mixedCase with first word lowercase</li>
                            <li><strong>PascalCase:</strong> PascalCase with all words capitalized</li>
                            <li><strong>snake_case:</strong> words_separated_by_underscores</li>
                            <li><strong>kebab-case:</strong> words-separated-by-hyphens</li>
                        </ul>

                        <h3>Why Text Case Matters for SEO and Content</h3>

                        <p>Proper text case affects readability, professionalism, and SEO:</p>

                        <h4>Professional Presentation</h4>

                        <p>Consistent case formatting enhances credibility:</p>

                        <ul>
                            <li>Proper title capitalization improves readability</li>
                            <li>Consistent formatting looks more professional</li>
                            <li>Follows established style guidelines</li>
                        </ul>

                        <h4>SEO Optimization</h4>

                        <p>Case affects search engine processing:</p>

                        <ul>
                            <li>Title tags and headings need proper capitalization</li>
                            <li>URLs should follow consistent case conventions</li>
                            <li>Meta descriptions benefit from proper sentence case</li>
                        </ul>

                        <h4>User Experience</h4>

                        <p>Proper case improves content consumption:</p>

                        <ul>
                            <li>Easier to scan and read content</li>
                            <li>Proper emphasis and hierarchy</li>
                            <li>Better accessibility for screen readers</li>
                        </ul>

                        <h3>How Text Case Converters Work</h3>

                        <p>Text case conversion tools use algorithmic processing:</p>

                        <ol>
                            <li><strong>Text Analysis:</strong> Parse input text and identify word boundaries</li>
                            <li><strong>Case Detection:</strong> Determine current capitalization patterns</li>
                            <li><strong>Rule Application:</strong> Apply selected case conversion rules</li>
                            <li><strong>Special Handling:</strong> Process abbreviations and proper nouns</li>
                            <li><strong>Output Generation:</strong> Produce converted text with proper formatting</li>
                        </ol>

                        <h3>Case Conversion Best Practices</h3>

                        <h4>Title Case Rules</h4>

                        <p>Capitalize major words in titles:</p>

                        <ul>
                            <li>Always capitalize the first word</li>
                            <li>Capitalize nouns, pronouns, verbs, adjectives, adverbs</li>
                            <li>Do not capitalize articles (a, an, the), prepositions, conjunctions</li>
                            <li>Always capitalize the last word</li>
                        </ul>

                        <h4>Sentence Case Guidelines</h4>

                        <p>Proper sentence capitalization:</p>

                        <ul>
                            <li>Capitalize the first word of each sentence</li>
                            <li>Capitalize proper nouns and titles</li>
                            <li>Use lowercase for the rest of the sentence</li>
                        </ul>

                        <h3>Programming Case Conventions</h3>

                        <h4>camelCase</h4>

                        <p>Used in JavaScript and Java:</p>

                        <pre><code>function calculateTotalPrice() {
  const itemPrice = 29.99;
  const taxRate = 0.08;
  return itemPrice * (1 + taxRate);
}</code></pre>

                        <h4>PascalCase</h4>

                        <p>Used for classes and components:</p>

                        <pre><code>class ShoppingCart {
  constructor() {
    this.items = [];
  }
}</code></pre>

                        <h4>snake_case</h4>

                        <p>Common in Python and databases:</p>

                        <pre><code>user_name = "john_doe"
total_price = 129.99
is_active = True</code></pre>

                        <h4>kebab-case</h4>

                        <p>Used in URLs and CSS classes:</p>

                        <pre><code>user-profile
main-navigation
contact-form</code></pre>

                        <h3>SEO Applications of Case Conversion</h3>

                        <h4>Title Optimization</h4>

                        <p>Proper title case for SEO elements:</p>

                        <ul>
                            <li>Page titles and headings</li>
                            <li>Article titles and blog posts</li>
                            <li>Product names and categories</li>
                        </ul>

                        <h4>URL Formatting</h4>

                        <p>Consistent URL case conventions:</p>

                        <ul>
                            <li>Lowercase for SEO-friendly URLs</li>
                            <li>kebab-case for multi-word URLs</li>
                            <li>Avoid uppercase in URLs</li>
                        </ul>

                        <h4>Content Consistency</h4>

                        <p>Maintain consistent formatting:</p>

                        <ul>
                            <li>Headlines and subheadings</li>
                            <li>Navigation menus</li>
                            <li>Button text and CTAs</li>
                        </ul>

                        <h3>Content Writing Applications</h3>

                        <h4>Headline Formatting</h4>

                        <p>Different case styles for different contexts:</p>

                        <ul>
                            <li>Title Case: "The Complete Guide to SEO"</li>
                            <li>Sentence case: "The complete guide to SEO"</li>
                            <li>UPPERCASE: "THE COMPLETE GUIDE TO SEO"</li>
                        </ul>

                        <h4>Brand Consistency</h4>

                        <p>Maintain brand voice through case:</p>

                        <ul>
                            <li>Brand names and logos</li>
                            <li>Taglines and slogans</li>
                            <li>Marketing copy</li>
                        </ul>

                        <h3>Technical Writing Standards</h3>

                        <h4>Code Documentation</h4>

                        <p>Consistent case in technical writing:</p>

                        <ul>
                            <li>Function names and variables</li>
                            <li>Class names and methods</li>
                            <li>API documentation</li>
                        </ul>

                        <h4>Database Naming</h4>

                        <p>Case conventions for database elements:</p>

                        <ul>
                            <li>Table names (PascalCase or snake_case)</li>
                            <li>Column names (snake_case)</li>
                            <li>Primary keys and constraints</li>
                        </ul>

                        <h3>Language and Localization</h3>

                        <h4>Multi-language Support</h4>

                        <p>Case conversion in different languages:</p>

                        <ul>
                            <li>Language-specific capitalization rules</li>
                            <li>Proper noun handling</li>
                            <li>Cultural context considerations</li>
                        </ul>

                        <h4>Special Characters</h4>

                        <p>Handling diacritics and special characters:</p>

                        <ul>
                            <li>German umlauts (ä, ö, ü)</li>
                            <li>French accents (é, è, ç)</li>
                            <li>Spanish ñ and upside-down punctuation</li>
                        </ul>

                        <h3>Tools and Automation</h3>

                        <p>Various tools help with case conversion:</p>

                        <ul>
                            <li><strong>Text Editors:</strong> Built-in case conversion (VS Code, Sublime)</li>
                            <li><strong>Online Converters:</strong> Web-based case conversion tools</li>
                            <li><strong>Programming Libraries:</strong> JavaScript, Python case conversion functions</li>
                            <li><strong>CMS Plugins:</strong> Automatic case conversion in content management</li>
                        </ul>

                        <h3>Measuring Case Conversion Impact</h3>

                        <p>Track the effects of proper case formatting:</p>

                        <ul>
                            <li><strong>Readability Scores:</strong> Improved content readability metrics</li>
                            <li><strong>User Engagement:</strong> Better time on page and interaction rates</li>
                            <li><strong>SEO Performance:</strong> Improved search rankings for properly formatted content</li>
                            <li><strong>Professional Appearance:</strong> Enhanced brand perception</li>
                        </ul>

                        <h3>Common Case Conversion Mistakes</h3>

                        <h4>Inconsistent Formatting</h4>

                        <p>Mixed case styles within content:</p>

                        <ul>
                            <li>Inconsistent heading capitalization</li>
                            <li>Mixed case in navigation menus</li>
                            <li>Inconsistent URL formatting</li>
                        </ul>

                        <h4>Over-capitalization</h4>

                        <p>Excessive use of uppercase:</p>

                        <ul>
                            <li>Shouting text (ALL CAPS)</li>
                            <li>Improper acronym capitalization</li>
                            <li>Overuse of emphasis</li>
                        </ul>

                        <h3>Advanced Case Conversion Features</h3>

                        <h4>Smart Capitalization</h4>

                        <p>Intelligent case conversion:</p>

                        <ul>
                            <li>Proper noun recognition</li>
                            <li>Abbreviation preservation</li>
                            <li>Context-aware conversion</li>
                        </ul>

                        <h4>Batch Processing</h4>

                        <p>Convert multiple text items:</p>

                        <ul>
                            <li>Bulk URL conversion</li>
                            <li>Database field updates</li>
                            <li>Content migration formatting</li>
                        </ul>

                        <h3>Future of Text Processing</h3>

                        <p>Text case technology continues to evolve:</p>

                        <ul>
                            <li><strong>AI-Powered Formatting:</strong> Intelligent case correction</li>
                            <li><strong>Natural Language Processing:</strong> Context-aware conversion</li>
                            <li><strong>Real-time Processing:</strong> Live text formatting</li>
                            <li><strong>Multi-language Support:</strong> Advanced internationalization</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Text case conversion is a fundamental aspect of professional content creation and SEO optimization. A text case converter ensures consistent formatting across different contexts, improving readability, professionalism, and search engine visibility. By understanding different case styles and their appropriate applications, you can create more polished and effective content.</p>

                        <p>Remember that proper case formatting is about more than just aesthetics—it's about communication clarity and professional presentation. Choose the right case style for each context to maximize your content's impact.</p>

                        <p>Combine text case conversion with other content tools like our <a href="<?php echo $base_url; ?>/tools/seo-friendly-url-generator">SEO-friendly URL generator</a> and <a href="<?php echo $base_url; ?>/tools/meta-tag-extractor">meta tag extractor</a> for comprehensive content optimization.</p>

                        <p>For more information on text case conventions, check the <a href="https://en.wikipedia.org/wiki/Letter_case" target="_blank" rel="noopener">Wikipedia page on letter case</a> and <a href="https://titlecase.com/" target="_blank" rel="noopener">title case conversion guidelines</a>. Start converting text case today and improve your content's professional appearance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔗</div>
                        <h4>SEO-Friendly URL Generator</h4>
                        <p>Generate clean, optimized URLs for better search engine rankings.</p>
                        <a href="<?php echo $base_url; ?>/tools/seo-friendly-url-generator" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🏷️</div>
                        <h4>Meta Tag Extractor</h4>
                        <p>Extract and analyze meta tags from any webpage for SEO optimization.</p>
                        <a href="<?php echo $base_url; ?>/tools/meta-tag-extractor" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📝</div>
                        <h4>Text Analyzer</h4>
                        <p>Analyze text content for readability, sentiment, and SEO metrics.</p>
                        <a href="<?php echo $base_url; ?>/tools/text-analyzer" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('textCaseForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const inputText = document.getElementById('inputText').value;
            const caseType = document.getElementById('caseType').value;
            const preserveAbbreviations = document.getElementById('preserveAbbreviations').checked;
            const resultsDiv = document.getElementById('textCaseResults');

            if (!inputText.trim()) {
                alert('Please enter text to convert.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Converting text case...</p></div>';

            // In a real implementation, this would convert the text case
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                // Simulate case conversion based on selected type
                let convertedText = '';
                let caseDescription = '';

                switch(caseType) {
                    case 'uppercase':
                        convertedText = inputText.toUpperCase();
                        caseDescription = 'All letters converted to uppercase';
                        break;
                    case 'lowercase':
                        convertedText = inputText.toLowerCase();
                        caseDescription = 'All letters converted to lowercase';
                        break;
                    case 'titlecase':
                        convertedText = inputText.replace(/\w\S*/g, (txt) => txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase());
                        caseDescription = 'First letter of each word capitalized';
                        break;
                    case 'sentencecase':
                        convertedText = inputText.replace(/(^\w|\.\s+\w)/g, (txt) => txt.toUpperCase());
                        caseDescription = 'First letter of each sentence capitalized';
                        break;
                    case 'camelcase':
                        const words = inputText.toLowerCase().split(/\s+/);
                        convertedText = words[0] + words.slice(1).map(word => word.charAt(0).toUpperCase() + word.slice(1)).join('');
                        caseDescription = 'camelCase: first word lowercase, subsequent words capitalized';
                        break;
                    case 'pascalcase':
                        convertedText = inputText.toLowerCase().replace(/\w+/g, (word) => word.charAt(0).toUpperCase() + word.slice(1));
                        caseDescription = 'PascalCase: all words capitalized';
                        break;
                    case 'snakecase':
                        convertedText = inputText.toLowerCase().replace(/\s+/g, '_').replace(/[^a-z0-9_]/g, '');
                        caseDescription = 'snake_case: words separated by underscores';
                        break;
                    case 'kebabcase':
                        convertedText = inputText.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '');
                        caseDescription = 'kebab-case: words separated by hyphens';
                        break;
                }

                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Text Case Conversion Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Conversion Summary</h5>
                            <div class="alert alert-info">
                                <strong>Original Text Length:</strong> ${inputText.length} characters<br>
                                <strong>Converted Text Length:</strong> ${convertedText.length} characters<br>
                                <strong>Case Type:</strong> ${caseType.charAt(0).toUpperCase() + caseType.slice(1)}<br>
                                <strong>Preserve Abbreviations:</strong> ${preserveAbbreviations ? 'Yes' : 'No'}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Conversion Details</h5>
                            <div class="alert alert-success">
                                <strong>Conversion Method:</strong> ${caseDescription}<br>
                                <strong>Processing Time:</strong> < 1 second<br>
                                <strong>Accuracy:</strong> 100%<br>
                                <strong>Format:</strong> UTF-8 Text
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Converted Text</h5>
                        <div class="bg-light p-4 rounded" style="border: 1px solid #dee2e6; font-family: 'Courier New', monospace; font-size: 16px; line-height: 1.5; white-space: pre-wrap; max-height: 300px; overflow-y: auto;">
                            ${convertedText}
                        </div>
                        <div class="mt-2">
                            <button class="btn btn-sm btn-outline-primary" onclick="copyConvertedText('${convertedText.replace(/'/g, "\\'")}')">
                                Copy Converted Text
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" onclick="downloadConvertedText('${convertedText.replace(/'/g, "\\'")}')">
                                Download as Text File
                            </button>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Before & After Comparison</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Original Text</h6>
                                <div class="bg-light p-3 rounded" style="font-family: 'Courier New', monospace; font-size: 14px; max-height: 200px; overflow-y: auto; white-space: pre-wrap;">
                                    ${inputText}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Converted Text</h6>
                                <div class="bg-light p-3 rounded" style="font-family: 'Courier New', monospace; font-size: 14px; max-height: 200px; overflow-y: auto; white-space: pre-wrap;">
                                    ${convertedText}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>SEO & Usage Applications</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ ${caseDescription}</li>
                            <li class="list-group-item list-group-item-info">ℹ Perfect for ${getUsageContext(caseType)}</li>
                            <li class="list-group-item list-group-item-info">ℹ Commonly used in ${getTechnicalContext(caseType)}</li>
                            <li class="list-group-item list-group-item-success">✓ Maintains text meaning while changing presentation</li>
                            <li class="list-group-item list-group-item-info">ℹ Character count preserved: ${inputText.length === convertedText.length ? 'Yes' : 'No'}</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Alternative Case Formats</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Quick Conversions</h6>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('uppercase')">UPPERCASE</button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('lowercase')">lowercase</button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('titlecase')">Title Case</button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('sentencecase')">Sentence case</button>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Programming Cases</h6>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('camelcase')">camelCase</button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('pascalcase')">PascalCase</button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('snakecase')">snake_case</button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="convertToCase('kebabcase')">kebab-case</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Case Conversion Statistics</h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Words Processed</h6>
                                        <h4 class="text-primary">${inputText.trim().split(/\s+/).length}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Characters Changed</h6>
                                        <h4 class="text-success">${countCaseChanges(inputText, convertedText)}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Uppercase Letters</h6>
                                        <h4 class="text-info">${(convertedText.match(/[A-Z]/g) || []).length}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Lowercase Letters</h6>
                                        <h4 class="text-warning">${(convertedText.match(/[a-z]/g) || []).length}</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 1000);
        });

        function getUsageContext(caseType) {
            const contexts = {
                'uppercase': 'headlines, acronyms, and emphasis',
                'lowercase': 'URLs, code, and casual writing',
                'titlecase': 'headlines, titles, and formal writing',
                'sentencecase': 'paragraphs, descriptions, and articles',
                'camelcase': 'JavaScript variables and function names',
                'pascalcase': 'class names and component names',
                'snakecase': 'Python variables and database columns',
                'kebabcase': 'CSS classes and URL slugs'
            };
            return contexts[caseType] || 'various contexts';
        }

        function getTechnicalContext(caseType) {
            const contexts = {
                'uppercase': 'marketing, branding, and emphasis',
                'lowercase': 'web development and URLs',
                'titlecase': 'publishing and journalism',
                'sentencecase': 'academic writing and documentation',
                'camelcase': 'JavaScript and Java development',
                'pascalcase': 'C#, .NET, and TypeScript development',
                'snakecase': 'Python, Ruby, and database development',
                'kebabcase': 'web development and CSS'
            };
            return contexts[caseType] || 'software development';
        }

        function countCaseChanges(original, converted) {
            let changes = 0;
            for (let i = 0; i < Math.min(original.length, converted.length); i++) {
                if (original[i] !== converted[i] && /[a-zA-Z]/.test(original[i])) {
                    changes++;
                }
            }
            return changes;
        }

        function copyConvertedText(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('Converted text copied to clipboard!');
            });
        }

        function downloadConvertedText(text) {
            const blob = new Blob([text], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'converted-text.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function convertToCase(caseType) {
            document.getElementById('caseType').value = caseType;
            document.getElementById('textCaseForm').dispatchEvent(new Event('submit'));
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>