<?php
$page_title = "Subdomain Finder - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Subdomain Finder</h1>
                    <p class="fade-in">Discover and analyze subdomains for comprehensive domain research and security assessment.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Find Subdomains</h3>
                        <form id="subdomainFinderForm">
                            <div class="mb-3">
                                <label for="domainInput" class="form-label">Domain Name</label>
                                <input type="text" class="form-control" id="domainInput" placeholder="example.com" required>
                                <small class="form-text text-muted">Enter the main domain (without www or http)</small>
                            </div>
                            <div class="mb-3">
                                <label for="scanType" class="form-label">Scan Method</label>
                                <select class="form-control" id="scanType">
                                    <option value="basic">Basic Scan (Fast)</option>
                                    <option value="comprehensive">Comprehensive Scan (Thorough)</option>
                                    <option value="bruteforce">Brute Force (Intensive)</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="wordlistSize" class="form-label">Wordlist Size</label>
                                <select class="form-control" id="wordlistSize">
                                    <option value="small">Small (100 words)</option>
                                    <option value="medium">Medium (500 words)</option>
                                    <option value="large">Large (1000 words)</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Find Subdomains</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Subdomain Discovery Results</h4>
                            <div id="subdomainResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Subdomain Discovery for SEO and Security</h2>

                        <p>Subdomain discovery is crucial for comprehensive domain analysis, security assessment, and SEO strategy. A subdomain finder helps identify all subdomains associated with a domain, revealing hidden content, potential security vulnerabilities, and optimization opportunities. This comprehensive guide explores subdomain enumeration, analysis techniques, and best practices for domain management.</p>

                        <h3>What are Subdomains?</h3>

                        <p>Subdomains are prefixes added to a domain name to create separate websites or services. They allow organizations to organize content, create separate sections, or host different applications under the same main domain.</p>

                        <h4>Common Subdomain Examples</h4>

                        <pre><code>blog.example.com - Blog section
shop.example.com - E-commerce store
api.example.com - API endpoints
mail.example.com - Email services
dev.example.com - Development environment</code></pre>

                        <h3>Why Subdomain Discovery Matters</h3>

                        <p>Subdomain enumeration provides valuable insights for multiple purposes:</p>

                        <h4>Security Assessment</h4>

                        <p>Identify potential security risks:</p>

                        <ul>
                            <li>Find forgotten or abandoned subdomains</li>
                            <li>Discover misconfigured services</li>
                            <li>Identify potential attack vectors</li>
                        </ul>

                        <h4>SEO Analysis</h4>

                        <p>Comprehensive site audit:</p>

                        <ul>
                            <li>Ensure all subdomains are indexed</li>
                            <li>Check for duplicate content issues</li>
                            <li>Optimize internal linking structure</li>
                        </ul>

                        <h4>Content Discovery</h4>

                        <p>Find hidden or forgotten content:</p>

                        <ul>
                            <li>Locate staging environments</li>
                            <li>Discover test sites and documentation</li>
                            <li>Identify backup or archive sites</li>
                        </ul>

                        <h3>How Subdomain Finders Work</h3>

                        <p>Subdomain enumeration uses multiple techniques to discover subdomains:</p>

                        <ol>
                            <li><strong>DNS Enumeration:</strong> Query DNS records for subdomain information</li>
                            <li><strong>Certificate Transparency:</strong> Check SSL certificate logs</li>
                            <li><strong>Search Engine Discovery:</strong> Find indexed subdomains in search results</li>
                            <li><strong>Brute Force Scanning:</strong> Test common subdomain names</li>
                            <li><strong>Web Archive Analysis:</strong> Check historical subdomain records</li>
                            <li><strong>Third-party Data Sources:</strong> Query external databases and APIs</li>
                        </ol>

                        <h3>Subdomain Discovery Methods</h3>

                        <h4>DNS-Based Discovery</h4>

                        <p>Query DNS records for subdomain information:</p>

                        <ul>
                            <li>Check NS, MX, and other DNS records</li>
                            <li>Use zone transfer attempts (if allowed)</li>
                            <li>Analyze SPF and DKIM records</li>
                        </ul>

                        <h4>Certificate Transparency Logs</h4>

                        <p>Search SSL certificate databases:</p>

                        <ul>
                            <li>All SSL certificates are logged publicly</li>
                            <li>Find subdomains with SSL certificates</li>
                            <li>Discover recently issued certificates</li>
                        </ul>

                        <h4>Search Engine Queries</h4>

                        <p>Use search operators to find subdomains:</p>

                        <pre><code>site:*.example.com
inurl:example.com -www.example.com</code></pre>

                        <h4>Brute Force Enumeration</h4>

                        <p>Test common subdomain names:</p>

                        <ul>
                            <li>Use wordlists of common prefixes</li>
                            <li>Test variations and permutations</li>
                            <li>Combine with numbers and special characters</li>
                        </ul>

                        <h3>Common Subdomain Types</h3>

                        <h4>Content Organization</h4>

                        <pre><code>blog.domain.com - Blog/Content
news.domain.com - News section
help.domain.com - Support/Knowledge base
docs.domain.com - Documentation</code></pre>

                        <h4>Services and Applications</h4>

                        <pre><code>api.domain.com - API endpoints
app.domain.com - Web application
mail.domain.com - Email services
ftp.domain.com - File transfer</code></pre>

                        <h4>Development and Testing</h4>

                        <pre><code>dev.domain.com - Development environment
staging.domain.com - Staging server
test.domain.com - Testing environment
beta.domain.com - Beta releases</code></pre>

                        <h3>Subdomain SEO Considerations</h3>

                        <h4>Indexing and Crawling</h4>

                        <p>Ensure subdomains are properly indexed:</p>

                        <ul>
                            <li>Submit subdomain sitemaps to search engines</li>
                            <li>Use cross-domain tracking in analytics</li>
                            <li>Implement proper internal linking</li>
                        </ul>

                        <h4>Duplicate Content</h4>

                        <p>Avoid duplicate content issues:</p>

                        <ul>
                            <li>Use canonical tags appropriately</li>
                            <li>Implement hreflang for international content</li>
                            <li>Set proper robots.txt rules</li>
                        </ul>

                        <h4>Link Equity Distribution</h4>

                        <p>Manage link equity across subdomains:</p>

                        <ul>
                            <li>Use 301 redirects for moved content</li>
                            <li>Implement proper cross-linking strategies</li>
                            <li>Monitor subdomain authority separately</li>
                        </ul>

                        <h3>Security Implications</h3>

                        <h4>Vulnerable Subdomains</h4>

                        <p>Common security issues with subdomains:</p>

                        <ul>
                            <li>Outdated software on forgotten subdomains</li>
                            <li>Misconfigured permissions</li>
                            <li>Default installations left exposed</li>
                        </ul>

                        <h4>Subdomain Takeover</h4>

                        <p>Risks of subdomain takeover attacks:</p>

                        <ul>
                            <li>DNS records pointing to non-existent services</li>
                            <li>Expired cloud service subdomains</li>
                            <li>Abandoned third-party service integrations</li>
                        </ul>

                        <h3>Subdomain Management Best Practices</h3>

                        <h4>Organization and Structure</h4>

                        <p>Maintain clear subdomain hierarchy:</p>

                        <ul>
                            <li>Use consistent naming conventions</li>
                            <li>Document all active subdomains</li>
                            <li>Regularly audit and clean up</li>
                        </ul>

                        <h4>SSL Certificates</h4>

                        <p>Secure all subdomains:</p>

                        <ul>
                            <li>Use wildcard SSL certificates</li>
                            <li>Implement HSTS headers</li>
                            <li>Regular certificate renewal monitoring</li>
                        </ul>

                        <h4>Monitoring and Maintenance</h4>

                        <p>Regular subdomain monitoring:</p>

                        <ul>
                            <li>Set up uptime monitoring</li>
                            <li>Monitor SSL certificate expiration</li>
                            <li>Regular security scanning</li>
                        </ul>

                        <h3>Tools for Subdomain Discovery</h3>

                        <p>Various tools help with subdomain enumeration:</p>

                        <ul>
                            <li><strong>Sublist3r:</strong> Comprehensive subdomain enumeration</li>
                            <li><strong>Amass:</strong> In-depth subdomain discovery</li>
                            <li><strong>Findomain:</strong> Fast subdomain finder</li>
                            <li><strong>Subfinder:</strong> Passive subdomain enumeration</li>
                        </ul>

                        <h3>Legal and Ethical Considerations</h3>

                        <h4>Permissible Scanning</h4>

                        <p>Always ensure legal authorization:</p>

                        <ul>
                            <li>Only scan domains you own or have permission for</li>
                            <li>Respect robots.txt directives</li>
                            <li>Avoid aggressive scanning that could cause disruption</li>
                        </ul>

                        <h4>Responsible Disclosure</h4>

                        <p>Report security findings appropriately:</p>

                        <ul>
                            <li>Use proper disclosure channels</li>
                            <li>Give organizations time to fix issues</li>
                            <li>Don't publicly expose vulnerabilities</li>
                        </ul>

                        <h3>Advanced Subdomain Techniques</h3>

                        <h4>Passive Enumeration</h4>

                        <p>Discover subdomains without direct scanning:</p>

                        <ul>
                            <li>Analyze public DNS records</li>
                            <li>Check certificate transparency logs</li>
                            <li>Monitor search engine results</li>
                        </ul>

                        <h4>Active Enumeration</h4>

                        <p>Direct testing and verification:</p>

                        <ul>
                            <li>DNS resolution testing</li>
                            <li>HTTP response checking</li>
                            <li>Service fingerprinting</li>
                        </ul>

                        <h3>Measuring Subdomain Performance</h3>

                        <p>Track subdomain effectiveness:</p>

                        <ul>
                            <li><strong>Traffic Analysis:</strong> Monitor visitor behavior</li>
                            <li><strong>SEO Performance:</strong> Check search rankings</li>
                            <li><strong>Conversion Rates:</strong> Measure goal completions</li>
                            <li><strong>Security Status:</strong> Regular vulnerability scanning</li>
                        </ul>

                        <h3>Future of Subdomain Discovery</h3>

                        <p>Subdomain enumeration technology evolves:</p>

                        <ul>
                            <li><strong>AI-Powered Discovery:</strong> Machine learning for pattern recognition</li>
                            <li><strong>Real-time Monitoring:</strong> Continuous subdomain tracking</li>
                            <li><strong>Automated Security:</strong> AI-driven vulnerability detection</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Subdomain discovery is essential for comprehensive domain analysis, security assessment, and SEO optimization. A subdomain finder helps identify all subdomains associated with a domain, revealing potential security vulnerabilities, content opportunities, and optimization areas. By regularly scanning and monitoring subdomains, you can maintain a secure and well-organized domain structure.</p>

                        <p>Remember that subdomain management requires ongoing attention. Regular audits, security monitoring, and proper organization are key to maintaining a healthy subdomain ecosystem.</p>

                        <p>Combine subdomain discovery with other domain analysis tools like our <a href="<?php echo $base_url; ?>/tools/domain-availability-checker">domain availability checker</a> and <a href="<?php echo $base_url; ?>/tools/port-scanner">port scanner</a> for comprehensive domain security and SEO assessment.</p>

                        <p>For more information on subdomain management and security, check the <a href="https://www.cloudflare.com/learning/dns/what-is-a-subdomain/" target="_blank" rel="noopener">Cloudflare subdomain guide</a> and <a href="https://owasp.org/www-community/attacks/Subdomain_Takeover" target="_blank" rel="noopener">OWASP subdomain takeover guide</a>. Start discovering subdomains today and improve your domain security and SEO performance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🌐</div>
                        <h4>Domain Availability Checker</h4>
                        <p>Check domain name availability across multiple TLDs and find the perfect domain.</p>
                        <a href="<?php echo $base_url; ?>/tools/domain-availability-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔒</div>
                        <h4>Website Security Checker</h4>
                        <p>Scan your website for security vulnerabilities and SSL certificate status.</p>
                        <a href="<?php echo $base_url; ?>/tools/website-security-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>Port Scanner</h4>
                        <p>Scan and analyze open ports on your server to ensure security and optimize performance.</p>
                        <a href="<?php echo $base_url; ?>/tools/port-scanner" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('subdomainFinderForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const domain = document.getElementById('domainInput').value.trim();
            const scanType = document.getElementById('scanType').value;
            const wordlistSize = document.getElementById('wordlistSize').value;
            const resultsDiv = document.getElementById('subdomainResults');

            if (!domain) {
                alert('Please enter a domain name.');
                return;
            }

            // Basic domain validation
            const domainRegex = /^[a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;
            if (!domainRegex.test(domain)) {
                alert('Please enter a valid domain name.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Scanning for subdomains...</p></div>';

            // In a real implementation, this would make API calls to subdomain discovery services
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-warning">
                        <strong>⚠️ Ethical Notice:</strong> Subdomain scanning should only be performed on domains you own or have explicit permission to scan. Unauthorized scanning may violate terms of service and legal agreements.
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Scan Summary</h5>
                            <div class="alert alert-info">
                                <strong>Domain:</strong> ${domain}<br>
                                <strong>Scan Method:</strong> ${scanType.replace(/^\w/, c => c.toUpperCase())}<br>
                                <strong>Subdomains Found:</strong> 8<br>
                                <strong>Scan Duration:</strong> 3.2 seconds<br>
                                <strong>Status:</strong> Completed
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Discovery Statistics</h5>
                            <div class="alert alert-success">
                                <strong>Active Subdomains:</strong> 6<br>
                                <strong>Inactive/Redirected:</strong> 2<br>
                                <strong>With SSL:</strong> 5<br>
                                <strong>Potential Issues:</strong> 1
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Discovered Subdomains</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Subdomain</th>
                                        <th>Status</th>
                                        <th>IP Address</th>
                                        <th>SSL</th>
                                        <th>Response</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>www.${domain}</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>192.168.1.100</td>
                                        <td><span class="badge bg-success">Yes</span></td>
                                        <td>200 OK</td>
                                    </tr>
                                    <tr>
                                        <td>mail.${domain}</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>192.168.1.101</td>
                                        <td><span class="badge bg-success">Yes</span></td>
                                        <td>200 OK</td>
                                    </tr>
                                    <tr>
                                        <td>blog.${domain}</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>192.168.1.102</td>
                                        <td><span class="badge bg-success">Yes</span></td>
                                        <td>200 OK</td>
                                    </tr>
                                    <tr>
                                        <td>api.${domain}</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>192.168.1.103</td>
                                        <td><span class="badge bg-warning">No</span></td>
                                        <td>200 OK</td>
                                    </tr>
                                    <tr>
                                        <td>dev.${domain}</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>192.168.1.104</td>
                                        <td><span class="badge bg-success">Yes</span></td>
                                        <td>200 OK</td>
                                    </tr>
                                    <tr>
                                        <td>staging.${domain}</td>
                                        <td><span class="badge bg-warning">Redirect</span></td>
                                        <td>192.168.1.105</td>
                                        <td><span class="badge bg-success">Yes</span></td>
                                        <td>301 Moved</td>
                                    </tr>
                                    <tr>
                                        <td>test.${domain}</td>
                                        <td><span class="badge bg-secondary">Inactive</span></td>
                                        <td>N/A</td>
                                        <td><span class="badge bg-secondary">N/A</span></td>
                                        <td>No Response</td>
                                    </tr>
                                    <tr>
                                        <td>ftp.${domain}</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td>192.168.1.106</td>
                                        <td><span class="badge bg-warning">No</span></td>
                                        <td>220 Ready</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>SEO & Security Analysis</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ Main website (www) properly configured with SSL</li>
                            <li class="list-group-item list-group-item-info">ℹ API subdomain lacks SSL - consider implementing HTTPS</li>
                            <li class="list-group-item list-group-item-success">✓ Blog subdomain active and secure</li>
                            <li class="list-group-item list-group-item-warning">⚠ FTP subdomain exposed without SSL - security risk</li>
                            <li class="list-group-item list-group-item-info">ℹ Staging environment redirects properly</li>
                            <li class="list-group-item list-group-item-warning">⚠ Test subdomain inactive - potential security concern</li>
                            <li class="list-group-item list-group-item-success">✓ Development environment properly isolated</li>
                            <li class="list-group-item list-group-item-info">ℹ Consider implementing subdomain monitoring</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Recommendations</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Security Improvements</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">• Enable SSL on API subdomain</li>
                                    <li class="list-group-item">• Secure FTP with SSL/TLS</li>
                                    <li class="list-group-item">• Remove or secure test subdomain</li>
                                    <li class="list-group-item">• Implement subdomain access controls</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>SEO Optimizations</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">• Submit all subdomains to search engines</li>
                                    <li class="list-group-item">• Create separate sitemaps for each subdomain</li>
                                    <li class="list-group-item">• Implement cross-subdomain linking</li>
                                    <li class="list-group-item">• Monitor subdomain indexing status</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Subdomain Architecture Overview</h5>
                        <div class="alert alert-info">
                            <strong>Content Subdomains:</strong> blog.${domain} (active blog)<br>
                            <strong>Service Subdomains:</strong> mail.${domain}, ftp.${domain}, api.${domain}<br>
                            <strong>Development Subdomains:</strong> dev.${domain}, staging.${domain}<br>
                            <strong>Security Status:</strong> 5/8 subdomains have SSL certificates<br>
                            <strong>Monitoring Recommendation:</strong> Implement automated subdomain health checks
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 3200);
        });
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>