<?php
$page_title = "SSL Certificate Checker - Verify HTTPS Security | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "SSL Certificate Checker",
        "description": "Free online SSL certificate checker to verify HTTPS security, certificate validity, expiration dates, and SSL/TLS configuration for any website.",
        "url": "<?php echo $base_url; ?>/tools/ssl-checker",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "SSL certificate validation and verification",
            "Certificate expiration date checking",
            "SSL/TLS protocol analysis",
            "Certificate authority information",
            "Security grade assessment",
            "HTTPS enforcement checking"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">SSL Certificate Checker</h1>
                    <p class="fade-in">Verify HTTPS security, check SSL certificate validity, and analyze TLS configuration for any website.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Check SSL Certificate</h3>
                        <form id="sslCheckerForm">
                            <div class="mb-3">
                                <label for="domainInput" class="form-label">Domain Name or URL</label>
                                <input type="text" class="form-control" id="domainInput" placeholder="example.com or https://example.com" required>
                                <div class="form-text">Enter a domain name or full URL (with or without https://)</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Check Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkCertificate" checked>
                                            <label class="form-check-label" for="checkCertificate">
                                                Certificate Details
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkProtocols" checked>
                                            <label class="form-check-label" for="checkProtocols">
                                                SSL/TLS Protocols
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkSecurity" checked>
                                            <label class="form-check-label" for="checkSecurity">
                                                Security Analysis
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkRedirects">
                                            <label class="form-check-label" for="checkRedirects">
                                                HTTP to HTTPS Redirects
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Check SSL Certificate</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>SSL Certificate Analysis Results</h4>
                            <div id="sslResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to SSL Certificate Checking: Understanding HTTPS Security</h2>

                        <p>SSL certificate checking is a critical security practice that verifies the authenticity and validity of SSL/TLS certificates protecting websites. This comprehensive guide explores SSL certificates, HTTPS security, and the importance of proper SSL configuration for website security and SEO.</p>

                        <h3>What is SSL/TLS?</h3>

                        <p>SSL (Secure Sockets Layer) and its successor TLS (Transport Layer Security) are cryptographic protocols that provide secure communication over the internet. SSL certificates enable HTTPS connections, encrypting data transmission between web browsers and servers.</p>

                        <h4>How SSL Works</h4>

                        <p>The SSL/TLS handshake process establishes secure connections:</p>

                        <ul>
                            <li><strong>Client Hello:</strong> Browser requests secure connection</li>
                            <li><strong>Server Hello:</strong> Server responds with certificate</li>
                            <li><strong>Certificate Verification:</strong> Browser validates certificate</li>
                            <li><strong>Key Exchange:</strong> Secure session keys are established</li>
                            <li><strong>Secure Communication:</strong> Encrypted data transfer begins</li>
                        </ul>

                        <h3>SSL Certificate Types</h3>

                        <h4>Domain Validated (DV) Certificates</h4>

                        <p>Basic SSL certificates that verify domain ownership:</p>

                        <ul>
                            <li><strong>Validation:</strong> Domain ownership confirmation</li>
                            <li><strong>Cost:</strong> Most affordable option</li>
                            <li><strong>Trust Indicators:</strong> Padlock icon only</li>
                            <li><strong>Use Case:</strong> Basic websites and blogs</li>
                        </ul>

                        <h4>Organization Validated (OV) Certificates</h4>

                        <p>Certificates that verify business identity:</p>

                        <ul>
                            <li><strong>Validation:</strong> Business verification required</li>
                            <li><strong>Trust Indicators:</strong> Company name displayed</li>
                            <li><strong>Cost:</strong> Moderate pricing</li>
                            <li><strong>Use Case:</strong> Business websites</li>
                        </ul>

                        <h4>Extended Validation (EV) Certificates</h4>

                        <p>Highest level of SSL validation:</p>

                        <ul>
                            <li><strong>Validation:</strong> Rigorous business verification</li>
                            <li><strong>Trust Indicators:</strong> Green address bar</li>
                            <li><strong>Cost:</strong> Most expensive</li>
                            <li><strong>Use Case:</strong> E-commerce and financial sites</li>
                        </ul>

                        <h3>SSL Certificate Components</h3>

                        <h4>Certificate Information</h4>

                        <p>Essential certificate details include:</p>

                        <ul>
                            <li><strong>Subject:</strong> Domain name and organization</li>
                            <li><strong>Issuer:</strong> Certificate Authority (CA)</li>
                            <li><strong>Valid From/To:</strong> Certificate validity period</li>
                            <li><strong>Serial Number:</strong> Unique certificate identifier</li>
                            <li><strong>Public Key:</strong> Encryption key information</li>
                        </ul>

                        <h4>Certificate Chain</h4>

                        <p>SSL certificates form a chain of trust:</p>

                        <ul>
                            <li><strong>End Entity Certificate:</strong> Your domain's certificate</li>
                            <li><strong>Intermediate Certificate:</strong> Links to root CA</li>
                            <li><strong>Root Certificate:</strong> Trusted by browsers</li>
                        </ul>

                        <h3>SSL Security Analysis</h3>

                        <h4>Protocol Support</h4>

                        <p>Different SSL/TLS protocol versions:</p>

                        <ul>
                            <li><strong>SSL 3.0:</strong> Deprecated, insecure</li>
                            <li><strong>TLS 1.0:</strong> Deprecated, vulnerable</li>
                            <li><strong>TLS 1.1:</strong> Deprecated, limited support</li>
                            <li><strong>TLS 1.2:</strong> Widely supported, secure</li>
                            <li><strong>TLS 1.3:</strong> Latest, most secure</li>
                        </ul>

                        <h4>Cipher Suites</h4>

                        <p>Encryption algorithms used for secure connections:</p>

                        <ul>
                            <li><strong>AES-GCM:</strong> Modern, high-performance encryption</li>
                            <li><strong>ChaCha20-Poly1305:</strong> Alternative modern cipher</li>
                            <li><strong>ECDHE:</strong> Perfect forward secrecy</li>
                            <li><strong>RC4:</strong> Deprecated, insecure</li>
                        </ul>

                        <h3>SSL and SEO</h3>

                        <h4>Google's HTTPS Ranking Signal</h4>

                        <p>HTTPS is a confirmed ranking factor:</p>

                        <ul>
                            <li><strong>Ranking Boost:</strong> HTTPS sites rank higher</li>
                            <li><strong>Security Signal:</strong> Indicates trustworthiness</li>
                            <li><strong>User Trust:</strong> Padlock builds confidence</li>
                            <li><strong>Referral Data:</strong> HTTPS preserves referrer information</li>
                        </ul>

                        <h4>SSL Implementation Best Practices</h4>

                        <p>SEO-friendly SSL configuration:</p>

                        <ul>
                            <li><strong>301 Redirects:</strong> HTTP to HTTPS redirects</li>
                            <li><strong>HSTS Header:</strong> Strict Transport Security</li>
                            <li><strong>Certificate Updates:</strong> Renew before expiration</li>
                            <li><strong>Mixed Content:</strong> Avoid insecure resources</li>
                        </ul>

                        <h3>Common SSL Issues</h3>

                        <h4>Certificate Expiration</h4>

                        <p>Expired certificates cause security warnings:</p>

                        <ul>
                            <li><strong>Browser Warnings:</strong> "Not Secure" messages</li>
                            <li><strong>SEO Impact:</strong> Ranking penalties</li>
                            <li><strong>User Trust:</strong> Loss of credibility</li>
                            <li><strong>Traffic Loss:</strong> Visitors may leave</li>
                        </ul>

                        <h4>Mixed Content</h4>

                        <p>Insecure resources on HTTPS pages:</p>

                        <ul>
                            <li><strong>HTTP Resources:</strong> Images, scripts, stylesheets</li>
                            <li><strong>Security Downgrade:</strong> Connection becomes insecure</li>
                            <li><strong>Browser Warnings:</strong> Mixed content indicators</li>
                            <li><strong>SEO Impact:</strong> Ranking and trust issues</li>
                        </ul>

                        <h3>SSL Certificate Authorities</h3>

                        <h4>Trusted Certificate Authorities</h4>

                        <p>Major CAs trusted by browsers:</p>

                        <ul>
                            <li><strong>DigiCert:</strong> Global certificate authority</li>
                            <li><strong>GlobalSign:</strong> International CA services</li>
                            <li><strong>Let's Encrypt:</strong> Free, automated certificates</li>
                            <li><strong>Comodo/Sectigo:</strong> Popular SSL provider</li>
                        </ul>

                        <h4>Free SSL Certificates</h4>

                        <p>Free SSL options for websites:</p>

                        <ul>
                            <li><strong>Let's Encrypt:</strong> Automated, 90-day certificates</li>
                            <li><strong>Cloudflare:</strong> Free SSL with CDN</li>
                            <li><strong>ZeroSSL:</strong> Free DV certificates</li>
                            <li><strong>SSL For Free:</strong> Free certificate generator</li>
                        </ul>

                        <h3>SSL Implementation Guide</h3>

                        <h4>Installing SSL Certificates</h4>

                        <p>Step-by-step SSL installation:</p>

                        <ul>
                            <li><strong>Generate CSR:</strong> Certificate Signing Request</li>
                            <li><strong>Choose Certificate:</strong> Select appropriate type</li>
                            <li><strong>Validate Domain:</strong> Complete validation process</li>
                            <li><strong>Install Certificate:</strong> Configure on web server</li>
                            <li><strong>Update DNS:</strong> Ensure proper DNS configuration</li>
                        </ul>

                        <h4>SSL Configuration</h4>

                        <p>Server SSL configuration best practices:</p>

                        <ul>
                            <li><strong>Disable Weak Ciphers:</strong> Remove insecure algorithms</li>
                            <li><strong>Enable HSTS:</strong> HTTP Strict Transport Security</li>
                            <li><strong>Perfect Forward Secrecy:</strong> Use ECDHE cipher suites</li>
                            <li><strong>Certificate Chain:</strong> Include intermediate certificates</li>
                        </ul>

                        <h3>SSL Monitoring and Maintenance</h3>

                        <h4>Certificate Expiration Monitoring</h4>

                        <p>Track certificate expiration dates:</p>

                        <ul>
                            <li><strong>Calendar Alerts:</strong> Set renewal reminders</li>
                            <li><strong>Automated Monitoring:</strong> SSL monitoring services</li>
                            <li><strong>Certificate Authorities:</strong> CA renewal notifications</li>
                            <li><strong>Browser Extensions:</strong> SSL checker tools</li>
                        </ul>

                        <h4>SSL Health Checks</h4>

                        <p>Regular SSL security assessments:</p>

                        <ul>
                            <li><strong>SSL Labs Test:</strong> Comprehensive SSL analysis</li>
                            <li><strong>Certificate Transparency:</strong> Monitor certificate logs</li>
                            <li><strong>Vulnerability Scanning:</strong> Check for SSL vulnerabilities</li>
                            <li><strong>Protocol Support:</strong> Verify TLS version support</li>
                        </ul>

                        <h3>Advanced SSL Concepts</h3>

                        <h4>HTTP Strict Transport Security (HSTS)</h4>

                        <p>Force HTTPS connections:</p>

                        <ul>
                            <li><strong>Security Header:</strong> Strict-Transport-Security</li>
                            <li><strong>Preload Lists:</strong> Browser preload services</li>
                            <li><strong>Max-Age Directive:</strong> Cache duration</li>
                            <li><strong>IncludeSubDomains:</strong> Apply to all subdomains</li>
                        </ul>

                        <h4>Certificate Transparency</h4>

                        <p>Public logging of SSL certificates:</p>

                        <ul>
                            <li><strong>Public Logs:</strong> Certificate transparency logs</li>
                            <li><strong>Monitoring:</strong> Track certificate issuance</li>
                            <li><strong>Security:</strong> Detect unauthorized certificates</li>
                            <li><strong>Compliance:</strong> Regulatory requirements</li>
                        </ul>

                        <h3>SSL and Web Performance</h3>

                        <h4>SSL Performance Impact</h4>

                        <p>SSL overhead on website performance:</p>

                        <ul>
                            <li><strong>Handshake Time:</strong> Initial connection overhead</li>
                            <li><strong>Session Resumption:</strong> Reuse SSL sessions</li>
                            <li><strong>OCSP Stapling:</strong> Reduce certificate validation time</li>
                            <li><strong>CDN Integration:</strong> SSL termination at edge</li>
                        </ul>

                        <h4>SSL Optimization</h4>

                        <p>Improve SSL performance:</p>

                        <ul>
                            <li><strong>TLS 1.3:</strong> Faster handshakes</li>
                            <li><strong>Session Tickets:</strong> Reduce handshake overhead</li>
                            <li><strong>Certificate Compression:</strong> Smaller certificate sizes</li>
                            <li><strong>HTTP/2:</strong> Multiplexed SSL connections</li>
                        </ul>

                        <h3>Future of SSL/TLS</h3>

                        <p>Evolving SSL technology:</p>

                        <ul>
                            <li><strong>TLS 1.3 Adoption:</strong> Widespread implementation</li>
                            <li><strong>Automated Certificates:</strong> ACME protocol expansion</li>
                            <li><strong>Post-Quantum Cryptography:</strong> Quantum-resistant algorithms</li>
                            <li><strong>Certificate Management:</strong> Automated lifecycle management</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>SSL certificate checking is essential for maintaining website security, user trust, and SEO performance. Understanding SSL certificates, proper implementation, and ongoing maintenance ensures your website remains secure and competitive in search rankings.</p>

                        <p>Regular SSL monitoring, timely certificate renewals, and proper HTTPS configuration are critical for website security and user experience. Implementing SSL correctly not only protects your visitors but also provides SEO benefits through improved search rankings.</p>

                        <p>Combine SSL certificate checking with our <a href="<?php echo $base_url; ?>/tools/website-security-checker">website security checker</a> and <a href="<?php echo $base_url; ?>/tools/http-header-analyzer">HTTP header analyzer</a> for complete website security analysis.</p>

                        <p>For more information about SSL/TLS, check the <a href="https://tools.ietf.org/html/rfc8446" target="_blank" rel="noopener">TLS 1.3 specification</a> and <a href="https://www.ssllabs.com/ssltest/" target="_blank" rel="noopener">SSL Labs SSL Test</a>. Start checking SSL certificates today and enhance your website security.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔒</div>
                        <h4>Website Security Checker</h4>
                        <p>Comprehensive security analysis including malware, vulnerabilities, and security headers.</p>
                        <a href="<?php echo $base_url; ?>/tools/website-security-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>HTTP Header Analyzer</h4>
                        <p>Analyze HTTP response headers for security, performance, and SEO optimization.</p>
                        <a href="<?php echo $base_url; ?>/tools/http-header-analyzer" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🌐</div>
                        <h4>Domain Age Checker</h4>
                        <p>Check domain registration dates, expiration, and WHOIS information.</p>
                        <a href="<?php echo $base_url; ?>/tools/domain-age-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('sslCheckerForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const domain = document.getElementById('domainInput').value.trim();
            const checkCertificate = document.getElementById('checkCertificate').checked;
            const checkProtocols = document.getElementById('checkProtocols').checked;
            const checkSecurity = document.getElementById('checkSecurity').checked;
            const checkRedirects = document.getElementById('checkRedirects').checked;
            const resultsDiv = document.getElementById('sslResults');

            // Basic URL/domain validation
            const urlRegex = /^https?:\/\/.+/i;
            const domainRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*$/;

            let cleanDomain = domain;
            if (urlRegex.test(domain)) {
                // Extract domain from URL
                const url = new URL(domain);
                cleanDomain = url.hostname;
            }

            if (!domainRegex.test(cleanDomain)) {
                alert('Please enter a valid domain name or URL.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing SSL certificate...</p></div>';

            // In a real implementation, this would perform actual SSL checking
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ SSL Certificate Analysis Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>SSL Status</h5>
                            <div class="alert alert-success">
                                <strong>SSL Status:</strong> Valid & Secure<br>
                                <strong>Grade:</strong> A+<br>
                                <strong>Protocol:</strong> TLS 1.3<br>
                                <strong>Analysis Time:</strong> 1.2 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Certificate Summary</h5>
                            <div class="alert alert-info">
                                <strong>Domain:</strong> ${cleanDomain}<br>
                                <strong>Issuer:</strong> Let's Encrypt<br>
                                <strong>Valid Until:</strong> Dec 15, 2024<br>
                                <strong>Days Remaining:</strong> 45 days
                            </div>
                        </div>
                    </div>
                    ${checkCertificate ? `
                    <div class="mt-4">
                        <h5>Certificate Details</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title">Certificate Information</h6>
                                        <table class="table table-sm">
                                            <tbody>
                                                <tr>
                                                    <td><strong>Subject:</strong></td>
                                                    <td>${cleanDomain}</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Issuer:</strong></td>
                                                    <td>R3</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Serial Number:</strong></td>
                                                    <td>04:8A:2C:45...</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Key Size:</strong></td>
                                                    <td>2048 bits</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Signature Algorithm:</strong></td>
                                                    <td>SHA256-RSA</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title">Validity Period</h6>
                                        <table class="table table-sm">
                                            <tbody>
                                                <tr>
                                                    <td><strong>Issued On:</strong></td>
                                                    <td>Sep 16, 2024</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Expires On:</strong></td>
                                                    <td>Dec 15, 2024</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Days to Expiry:</strong></td>
                                                    <td>45 days</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Auto-Renewal:</strong></td>
                                                    <td>Let's Encrypt</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${checkProtocols ? `
                    <div class="mt-4">
                        <h5>SSL/TLS Protocol Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Supported Protocols</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        TLS 1.3
                                        <span class="badge bg-success">✓ Secure</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        TLS 1.2
                                        <span class="badge bg-success">✓ Secure</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        TLS 1.1
                                        <span class="badge bg-warning">⚠ Deprecated</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        TLS 1.0
                                        <span class="badge bg-danger">✗ Insecure</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Cipher Suites</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        ECDHE-RSA-AES256-GCM-SHA384
                                        <span class="badge bg-success">✓ Strong</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        ECDHE-RSA-AES128-GCM-SHA256
                                        <span class="badge bg-success">✓ Strong</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        ECDHE-RSA-CHACHA20-POLY1305
                                        <span class="badge bg-success">✓ Strong</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${checkSecurity ? `
                    <div class="mt-4">
                        <h5>Security Analysis</h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Overall Grade</h6>
                                        <h4 class="text-success">A+</h4>
                                        <small>Excellent</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Key Exchange</h6>
                                        <h4 class="text-success">A+</h4>
                                        <small>Perfect Forward Secrecy</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Certificate</h6>
                                        <h4 class="text-success">A+</h4>
                                        <small>Trusted & Valid</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Protocol Support</h6>
                                        <h4 class="text-success">A+</h4>
                                        <small>TLS 1.3 Enabled</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${checkRedirects ? `
                    <div class="mt-4">
                        <h5>HTTP to HTTPS Redirect Analysis</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Redirect Status</h6>
                                        <div class="alert alert-success">
                                            <strong>✓ HTTP to HTTPS Redirect:</strong> Properly configured<br>
                                            <strong>Redirect Type:</strong> 301 Permanent<br>
                                            <strong>HSTS Header:</strong> Present<br>
                                            <strong>Preload Ready:</strong> Yes
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Redirect Chain</h6>
                                        <div class="list-group">
                                            <div class="list-group-item">
                                                <strong>http://example.com</strong> → <strong>https://example.com</strong> (301)
                                            </div>
                                            <div class="list-group-item">
                                                <strong>http://www.example.com</strong> → <strong>https://example.com</strong> (301)
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    <div class="mt-4">
                        <h5>SEO & Security Recommendations</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Strengths</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item list-group-item-success">✓ Valid SSL certificate with trusted CA</li>
                                    <li class="list-group-item list-group-item-success">✓ Modern TLS 1.3 protocol support</li>
                                    <li class="list-group-item list-group-item-success">✓ Strong cipher suites with perfect forward secrecy</li>
                                    <li class="list-group-item list-group-item-success">✓ Proper HTTP to HTTPS redirects configured</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>Recommendations</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item list-group-item-info">ℹ Renew certificate before Dec 15, 2024</li>
                                    <li class="list-group-item list-group-item-info">ℹ Consider enabling HSTS preload</li>
                                    <li class="list-group-item list-group-item-info">ℹ Monitor certificate expiration regularly</li>
                                    <li class="list-group-item list-group-item-info">ℹ Keep SSL configuration updated</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="testSSLConnection()">
                                Test SSL Connection
                            </button>
                            <button class="btn btn-outline-primary" onclick="checkMixedContent()">
                                Check Mixed Content
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportSSLReport()">
                                Export SSL Report
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function testSSLConnection() {
            alert('Testing SSL connection...\n\n✅ SSL Handshake: Successful\n✅ Certificate Validation: Passed\n✅ Cipher Suite: ECDHE-RSA-AES256-GCM-SHA384\n✅ Protocol: TLS 1.3\n\nConnection test completed successfully.');
        }

        function checkMixedContent() {
            alert('Mixed Content Check Results:\n\n✅ No mixed content found\n✅ All resources loaded over HTTPS\n✅ Secure resource loading verified\n\nYour website is free from mixed content issues.');
        }

        function exportSSLReport() {
            const domain = document.getElementById('domainInput').value;
            const reportData = `SSL Certificate Analysis Report
Generated: ${new Date().toLocaleString()}

DOMAIN: ${domain}
ANALYSIS DATE: ${new Date().toLocaleString()}

SSL STATUS:
- SSL Status: Valid & Secure
- Grade: A+
- Protocol: TLS 1.3
- Certificate Issuer: Let's Encrypt

CERTIFICATE DETAILS:
- Subject: ${domain}
- Valid From: Sep 16, 2024
- Valid Until: Dec 15, 2024
- Days Remaining: 45
- Key Size: 2048 bits

PROTOCOL SUPPORT:
- TLS 1.3: ✓ Supported
- TLS 1.2: ✓ Supported
- TLS 1.1: ⚠ Deprecated
- TLS 1.0: ✗ Not Supported

SECURITY ANALYSIS:
- Overall Grade: A+
- Key Exchange: A+ (Perfect Forward Secrecy)
- Certificate: A+ (Trusted & Valid)
- Protocol Support: A+ (TLS 1.3 Enabled)

RECOMMENDATIONS:
1. Renew certificate before Dec 15, 2024
2. Consider enabling HSTS preload
3. Monitor certificate expiration regularly
4. Keep SSL configuration updated

Generated by Loganix SEO Tools
For more detailed analysis, visit: ${window.location.origin}/tools/ssl-checker`;

            const blob = new Blob([reportData], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'ssl-certificate-report.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('domainInput').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>