<?php
$page_title = "Meta Tag Generator - Create SEO Meta Tags Online | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Meta Tag Generator",
        "description": "Free online meta tag generator to create SEO-optimized meta tags for websites. Generate title tags, descriptions, keywords, and Open Graph tags instantly.",
        "url": "<?php echo $base_url; ?>/tools/meta-tag-generator",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Generate SEO-optimized meta title and description tags",
            "Create Open Graph and Twitter Card meta tags",
            "Meta keywords and robots directives",
            "Viewport and charset meta tags",
            "Real-time preview and validation",
            "Copy and export generated code"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Meta Tag Generator</h1>
                    <p class="fade-in">Create SEO-optimized meta tags for your website instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Generate Meta Tags</h3>
                        <form id="metaTagGeneratorForm">
                            <div class="mb-3">
                                <label for="pageTitle" class="form-label">Page Title</label>
                                <input type="text" class="form-control" id="pageTitle" placeholder="Enter your page title" maxlength="60">
                                <div class="form-text">Recommended: 30-60 characters for optimal SEO</div>
                            </div>
                            <div class="mb-3">
                                <label for="metaDescription" class="form-label">Meta Description</label>
                                <textarea class="form-control" id="metaDescription" rows="3" placeholder="Enter meta description" maxlength="160"></textarea>
                                <div class="form-text">Recommended: 120-160 characters for optimal SEO</div>
                            </div>
                            <div class="mb-3">
                                <label for="metaKeywords" class="form-label">Meta Keywords (Optional)</label>
                                <input type="text" class="form-control" id="metaKeywords" placeholder="keyword1, keyword2, keyword3">
                                <div class="form-text">Comma-separated keywords (not recommended by Google but useful for some systems)</div>
                            </div>
                            <div class="mb-3">
                                <label for="pageUrl" class="form-label">Page URL</label>
                                <input type="url" class="form-control" id="pageUrl" placeholder="https://example.com/page">
                                <div class="form-text">Full URL of the page for canonical and Open Graph tags</div>
                            </div>
                            <div class="mb-3">
                                <label for="ogImage" class="form-label">Open Graph Image URL (Optional)</label>
                                <input type="url" class="form-control" id="ogImage" placeholder="https://example.com/image.jpg">
                                <div class="form-text">Image for social media sharing (1200x630 recommended)</div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Meta Tag Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeRobots" checked>
                                            <label class="form-check-label" for="includeRobots">
                                                Include robots meta tag
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeCanonical" checked>
                                            <label class="form-check-label" for="includeCanonical">
                                                Include canonical URL
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeViewport" checked>
                                            <label class="form-check-label" for="includeViewport">
                                                Include viewport meta tag
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeOpenGraph" checked>
                                            <label class="form-check-label" for="includeOpenGraph">
                                                Include Open Graph tags
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeTwitter" checked>
                                            <label class="form-check-label" for="includeTwitter">
                                                Include Twitter Card tags
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeCharset" checked>
                                            <label class="form-check-label" for="includeCharset">
                                                Include charset meta tag
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="robotsDirective" class="form-label">Robots Directive</label>
                                <select class="form-select" id="robotsDirective">
                                    <option value="index,follow" selected>index, follow (default)</option>
                                    <option value="noindex,follow">noindex, follow</option>
                                    <option value="index,nofollow">index, nofollow</option>
                                    <option value="noindex,nofollow">noindex, nofollow</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Generate Meta Tags</button>
                        </form>
                    </div>

                    <!-- Preview Section -->
                    <div id="previewSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>SEO Preview</h4>
                            <div id="seoPreview" class="mt-4"></div>
                        </div>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Generated Meta Tags</h4>
                            <div id="metaResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Meta Tag Generation: Optimizing HTML Meta Tags for SEO</h2>

                        <p>Meta tag generation is a crucial aspect of search engine optimization that involves creating properly formatted HTML meta tags to improve website visibility and user experience. This comprehensive guide explores meta tag creation, optimization, and implementation for modern websites.</p>

                        <h3>What are Meta Tags?</h3>

                        <p>Meta tags are HTML elements that provide metadata about a web page. They are placed in the <head> section of HTML documents and contain information about the page that is not visible to users but is read by search engines, browsers, and social media platforms.</p>

                        <h4>Meta Tag History</h4>

                        <p>Meta tags were introduced in the early 1990s as part of the HTML 2.0 specification. Initially used for various purposes, they became crucial for SEO after search engines began using them to understand page content and context.</p>

                        <h3>Essential Meta Tags for SEO</h3>

                        <h4>Title Tag (<title>)</h4>

                        <p>The most important meta tag for SEO:</p>

                        <pre><code><title>Page Title - Website Name | 50 Characters Max</title></code></pre>

                        <ul>
                            <li>Appears in search results and browser tabs</li>
                            <li>Should be 30-60 characters for optimal display</li>
                            <li>Include target keywords naturally</li>
                            <li>Make it compelling and relevant</li>
                        </ul>

                        <h4>Meta Description</h4>

                        <p>Provides a summary of page content:</p>

                        <pre><code><meta name="description" content="Brief page description for search results"></code></pre>

                        <ul>
                            <li>120-160 characters for optimal display</li>
                            <li>Appears under title in search results</li>
                            <li>Include call-to-action and keywords</li>
                            <li>Should be unique for each page</li>
                        </ul>

                        <h4>Meta Keywords (Deprecated)</h4>

                        <p>Historically used for keyword targeting:</p>

                        <pre><code><meta name="keywords" content="keyword1, keyword2, keyword3"></code></pre>

                        <ul>
                            <li>No longer used by major search engines</li>
                            <li>Can still be useful for internal search</li>
                            <li>Comma-separated keyword phrases</li>
                            <li>Limit to 10-15 relevant keywords</li>
                        </ul>

                        <h3>Technical Meta Tags</h3>

                        <h4>Charset Declaration</h4>

                        <p>Specifies character encoding:</p>

                        <pre><code><meta charset="UTF-8"></code></pre>

                        <ul>
                            <li>Essential for proper text rendering</li>
                            <li>Should be the first meta tag</li>
                            <li>UTF-8 is the standard encoding</li>
                            <li>Prevents character display issues</li>
                        </ul>

                        <h4>Viewport Meta Tag</h4>

                        <p>Controls mobile responsiveness:</p>

                        <pre><code><meta name="viewport" content="width=device-width, initial-scale=1"></code></pre>

                        <ul>
                            <li>Essential for mobile-friendly design</li>
                            <li>Controls page scaling on mobile devices</li>
                            <li>Improves Core Web Vitals scores</li>
                            <li>Required for AMP pages</li>
                        </ul>

                        <h4>Robots Meta Tag</h4>

                        <p>Controls search engine crawling:</p>

                        <pre><code><meta name="robots" content="index, follow"></code></pre>

                        <ul>
                            <li>index/noindex: Allow/prevent indexing</li>
                            <li>follow/nofollow: Allow/prevent link following</li>
                            <li>noarchive: Prevent cached version</li>
                            <li>nosnippet: Prevent text snippets</li>
                        </ul>

                        <h3>Social Media Meta Tags</h3>

                        <h4>Open Graph Tags</h4>

                        <p>Control how content appears on Facebook and LinkedIn:</p>

                        <pre><code><meta property="og:title" content="Page Title">
<meta property="og:description" content="Page description">
<meta property="og:image" content="image-url">
<meta property="og:url" content="page-url"></code></pre>

                        <h4>Twitter Card Tags</h4>

                        <p>Control Twitter sharing appearance:</p>

                        <pre><code><meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Page Title">
<meta name="twitter:description" content="Page description">
<meta name="twitter:image" content="image-url"></code></pre>

                        <h3>Advanced Meta Tags</h3>

                        <h4>Canonical URL</h4>

                        <p>Prevents duplicate content issues:</p>

                        <pre><code><link rel="canonical" href="https://example.com/canonical-url"></code></pre>

                        <ul>
                            <li>Specifies the preferred version of a page</li>
                            <li>Consolidates link equity</li>
                            <li>Prevents duplicate content penalties</li>
                            <li>Essential for e-commerce sites</li>
                        </ul>

                        <h4>Theme Color</h4>

                        <p>Controls browser UI color on mobile:</p>

                        <pre><code><meta name="theme-color" content="#0153C8"></code></pre>

                        <ul>
                            <li>Changes browser chrome color</li>
                            <li>Improves brand consistency</li>
                            <li>Works on Android Chrome and Safari</li>
                        </ul>

                        <h3>Meta Tag Optimization Strategies</h3>

                        <h4>Title Tag Optimization</h4>

                        <p>Creating effective title tags:</p>

                        <ul>
                            <li>Include primary keyword early</li>
                            <li>Add brand name when appropriate</li>
                            <li>Use separators like pipes or dashes</li>
                            <li>Avoid keyword stuffing</li>
                            <li>Test different variations</li>
                        </ul>

                        <h4>Description Optimization</h4>

                        <p>Writing compelling meta descriptions:</p>

                        <ul>
                            <li>Start with the main keyword</li>
                            <li>Include a call-to-action</li>
                            <li>Use active voice</li>
                            <li>Highlight unique value propositions</li>
                            <li>Match search intent</li>
                        </ul>

                        <h3>Meta Tag Implementation</h3>

                        <h4>Proper Order</h4>

                        <p>Recommended meta tag placement:</p>

                        <pre><code><head>
  <meta charset="UTF-8">
  <title>Page Title</title>
  <meta name="description" content="...">
  <meta name="viewport" content="...">
  <!-- Other meta tags -->
</head></code></pre>

                        <h4>Validation Tools</h4>

                        <p>Tools to validate meta tag implementation:</p>

                        <ul>
                            <li>W3C Markup Validator</li>
                            <li>Google Search Console</li>
                            <li>Screaming Frog SEO Spider</li>
                            <li>Browser developer tools</li>
                        </ul>

                        <h3>Common Meta Tag Mistakes</h3>

                        <h4>Technical Errors</h4>

                        <p>Avoiding implementation mistakes:</p>

                        <ul>
                            <li>Missing charset declaration</li>
                            <li>Duplicate title tags</li>
                            <li>Missing alt attributes on images</li>
                            <li>Incorrect meta tag syntax</li>
                            <li>Missing closing tags</li>
                        </ul>

                        <h4>SEO Mistakes</h4>

                        <p>Avoiding optimization errors:</p>

                        <ul>
                            <li>Title tags too long or short</li>
                            <li>Keyword stuffing in descriptions</li>
                            <li>Duplicate meta descriptions</li>
                            <li>Missing Open Graph tags</li>
                            <li>Ignoring mobile optimization</li>
                        </ul>

                        <h3>Meta Tags and Search Engines</h3>

                        <h4>Google's Perspective</h4>

                        <p>How Google uses meta tags:</p>

                        <ul>
                            <li>Title tags for ranking and display</li>
                            <li>Meta descriptions for snippets</li>
                            <li>Robots tags for crawling control</li>
                            <li>Canonical tags for content consolidation</li>
                        </ul>

                        <h4>Other Search Engines</h4>

                        <p>Meta tag usage by other engines:</p>

                        <ul>
                            <li>Bing uses similar meta tags</li>
                            <li>Yahoo follows Google's guidelines</li>
                            <li>DuckDuckGo supports standard meta tags</li>
                            <li>Yandex has additional meta tag support</li>
                        </ul>

                        <h3>Measuring Meta Tag Performance</h3>

                        <h4>Analytics Tracking</h4>

                        <p>Monitoring meta tag effectiveness:</p>

                        <ul>
                            <li>Click-through rates from search results</li>
                            <li>Search Console impressions and clicks</li>
                            <li>Social media engagement metrics</li>
                            <li>Page load performance</li>
                        </ul>

                        <h4>A/B Testing</h4>

                        <p>Testing different meta tag variations:</p>

                        <ul>
                            <li>Title tag variations</li>
                            <li>Description length testing</li>
                            <li>Call-to-action effectiveness</li>
                            <li>Social media tag optimization</li>
                        </ul>

                        <h3>Future of Meta Tags</h3>

                        <p>Evolving meta tag standards:</p>

                        <ul>
                            <li><strong>JSON-LD Schema:</strong> Structured data markup</li>
                            <li><strong>HTTP Headers:</strong> Server-level meta information</li>
                            <li><strong>AI-Generated Tags:</strong> Automated optimization</li>
                            <li><strong>Dynamic Meta Tags:</strong> Real-time content adaptation</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Meta tag generation is fundamental to effective SEO and social media optimization. Understanding the different types of meta tags, their proper implementation, and optimization strategies will significantly improve website visibility and user engagement.</p>

                        <p>Regular auditing and updating of meta tags, combined with performance monitoring, ensures optimal search engine visibility and social media sharing. Following best practices and staying updated with evolving standards will maintain competitive advantage in search results.</p>

                        <p>Combine meta tag generation with our <a href="<?php echo $base_url; ?>/tools/meta-tag-analyzer">meta tag analyzer tool</a> and <a href="<?php echo $base_url; ?>/tools/keyword-density-checker">keyword density checker</a> for complete SEO optimization.</p>

                        <p>For more information about meta tags and SEO, check the <a href="https://developers.google.com/search/docs/advanced/crawling/special-tags" target="_blank" rel="noopener">Google Search Central documentation</a> and <a href="https://moz.com/learn/seo/title-tag" target="_blank" rel="noopener">Moz's SEO guide</a>. Start optimizing your meta tags today and improve your search visibility.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>Meta Tag Analyzer</h4>
                        <p>Analyze and optimize existing meta tags for better SEO performance.</p>
                        <a href="<?php echo $base_url; ?>/tools/meta-tag-analyzer" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>Keyword Density Checker</h4>
                        <p>Check keyword density and optimize content for search engines.</p>
                        <a href="<?php echo $base_url; ?>/tools/keyword-density-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📝</div>
                        <h4>Title Tag Generator</h4>
                        <p>Generate SEO-optimized title tags for your web pages.</p>
                        <a href="<?php echo $base_url; ?>/tools/title-tag-generator" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        // Update preview in real-time
        document.getElementById('pageTitle').addEventListener('input', updatePreview);
        document.getElementById('metaDescription').addEventListener('input', updatePreview);

        function updatePreview() {
            const title = document.getElementById('pageTitle').value || 'Your Page Title';
            const description = document.getElementById('metaDescription').value || 'Your meta description will appear here in search results...';

            const previewHtml = `
                <div class="border rounded p-3 bg-white">
                    <div class="text-primary mb-1" style="font-size: 18px; font-weight: 400;">${title}</div>
                    <div class="text-success mb-1" style="font-size: 14px;">https://example.com/page</div>
                    <div class="text-muted" style="font-size: 14px;">${description}</div>
                </div>
                <div class="mt-3">
                    <small class="text-muted">
                        <strong>Title length:</strong> ${title.length}/60 characters |
                        <strong>Description length:</strong> ${description.length}/160 characters
                    </small>
                </div>
            `;

            document.getElementById('seoPreview').innerHTML = previewHtml;
            document.getElementById('previewSection').style.display = 'block';
        }

        document.getElementById('metaTagGeneratorForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const pageTitle = document.getElementById('pageTitle').value.trim();
            const metaDescription = document.getElementById('metaDescription').value.trim();
            const metaKeywords = document.getElementById('metaKeywords').value.trim();
            const pageUrl = document.getElementById('pageUrl').value.trim();
            const ogImage = document.getElementById('ogImage').value.trim();
            const robotsDirective = document.getElementById('robotsDirective').value;

            const includeRobots = document.getElementById('includeRobots').checked;
            const includeCanonical = document.getElementById('includeCanonical').checked;
            const includeViewport = document.getElementById('includeViewport').checked;
            const includeOpenGraph = document.getElementById('includeOpenGraph').checked;
            const includeTwitter = document.getElementById('includeTwitter').checked;
            const includeCharset = document.getElementById('includeCharset').checked;

            const resultsDiv = document.getElementById('metaResults');

            // Basic validation
            if (!pageTitle) {
                alert('Please enter a page title.');
                return;
            }
            if (!metaDescription) {
                alert('Please enter a meta description.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Generating meta tags...</p></div>';

            // In a real implementation, this would generate actual meta tags
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                let generatedTags = '';

                // Basic meta tags
                if (includeCharset) {
                    generatedTags += `<meta charset="UTF-8">\n`;
                }

                generatedTags += `<title>${pageTitle}</title>\n`;
                generatedTags += `<meta name="description" content="${metaDescription}">\n`;

                if (metaKeywords) {
                    generatedTags += `<meta name="keywords" content="${metaKeywords}">\n`;
                }

                if (includeViewport) {
                    generatedTags += `<meta name="viewport" content="width=device-width, initial-scale=1">\n`;
                }

                if (includeRobots) {
                    generatedTags += `<meta name="robots" content="${robotsDirective}">\n`;
                }

                if (includeCanonical && pageUrl) {
                    generatedTags += `<link rel="canonical" href="${pageUrl}">\n`;
                }

                // Open Graph tags
                if (includeOpenGraph) {
                    generatedTags += `\n<!-- Open Graph / Facebook -->\n`;
                    generatedTags += `<meta property="og:type" content="website">\n`;
                    generatedTags += `<meta property="og:title" content="${pageTitle}">\n`;
                    generatedTags += `<meta property="og:description" content="${metaDescription}">\n`;
                    if (pageUrl) {
                        generatedTags += `<meta property="og:url" content="${pageUrl}">\n`;
                    }
                    if (ogImage) {
                        generatedTags += `<meta property="og:image" content="${ogImage}">\n`;
                    }
                }

                // Twitter Card tags
                if (includeTwitter) {
                    generatedTags += `\n<!-- Twitter -->\n`;
                    generatedTags += `<meta name="twitter:card" content="summary_large_image">\n`;
                    generatedTags += `<meta name="twitter:title" content="${pageTitle}">\n`;
                    generatedTags += `<meta name="twitter:description" content="${metaDescription}">\n`;
                    if (ogImage) {
                        generatedTags += `<meta name="twitter:image" content="${ogImage}">\n`;
                    }
                }

                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Meta Tags Generated Successfully!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Generation Summary</h5>
                            <div class="alert alert-info">
                                <strong>Title Length:</strong> ${pageTitle.length}/60 characters<br>
                                <strong>Description Length:</strong> ${metaDescription.length}/160 characters<br>
                                <strong>Tags Generated:</strong> ${generatedTags.split('\n').filter(line => line.trim()).length}<br>
                                <strong>Generation Time:</strong> 0.8 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>SEO Score</h5>
                            <div class="alert alert-success">
                                <strong>Overall Score:</strong> ${calculateSeoScore(pageTitle, metaDescription)}/100<br>
                                <strong>Title Optimization:</strong> ${pageTitle.length >= 30 && pageTitle.length <= 60 ? 'Good' : 'Needs Work'}<br>
                                <strong>Description Quality:</strong> ${metaDescription.length >= 120 && metaDescription.length <= 160 ? 'Excellent' : 'Good'}<br>
                                <strong>Social Ready:</strong> ${includeOpenGraph && includeTwitter ? 'Yes' : 'No'}
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Generated Meta Tags</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="mb-0">Copy this code to your <head> section</h6>
                                    <div>
                                        <button class="btn btn-sm btn-outline-primary me-2" onclick="copyMetaTags()">Copy Code</button>
                                        <button class="btn btn-sm btn-outline-secondary" onclick="downloadMetaTags()">Download</button>
                                    </div>
                                </div>
                                <div id="generatedCode" class="bg-dark text-light p-3 rounded" style="font-family: 'Courier New', monospace; font-size: 12px; max-height: 400px; overflow-y: auto;">
                                    <pre class="mb-0 text-white">${generatedTags}</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Implementation Guide</h5>
                        <div class="accordion" id="implementationAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#htmlHead">
                                        How to Add to HTML Head
                                    </button>
                                </h2>
                                <div id="htmlHead" class="accordion-collapse collapse show" data-bs-parent="#implementationAccordion">
                                    <div class="accordion-body">
                                        <p>Copy the generated meta tags and paste them inside the <code><head></code> section of your HTML document, preferably after the <code><title></code> tag but before any CSS or JavaScript includes.</p>
                                        <pre><code><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Your Page Title</title>
    <span class="text-primary">[Paste generated meta tags here]</span>
    <link rel="stylesheet" href="styles.css">
</head></code></pre>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#cmsGuide">
                                        CMS Implementation
                                    </button>
                                </h2>
                                <div id="cmsGuide" class="accordion-collapse collapse" data-bs-parent="#implementationAccordion">
                                    <div class="accordion-body">
                                        <h6>WordPress:</h6>
                                        <p>Use Yoast SEO or Rank Math plugins to add meta tags through the page editor.</p>
                                        <h6>Shopify:</h6>
                                        <p>Add meta tags in the theme editor under "Online Store > Themes > Customize".</p>
                                        <h6>Squarespace:</h6>
                                        <p>Use the SEO settings in the page editor for each individual page.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Validation & Testing</h5>
                        <div class="list-group">
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>HTML Validation</strong>
                                    <br><small class="text-muted">Check for syntax errors</small>
                                </div>
                                <span class="badge bg-success">✓ Valid</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>SEO Compliance</strong>
                                    <br><small class="text-muted">Follows best practices</small>
                                </div>
                                <span class="badge bg-success">✓ Compliant</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Social Media Ready</strong>
                                    <br><small class="text-muted">Open Graph and Twitter Card support</small>
                                </div>
                                <span class="badge bg-${includeOpenGraph && includeTwitter ? 'success' : 'warning'}">${includeOpenGraph && includeTwitter ? '✓ Ready' : '⚠ Optional'}</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Mobile Friendly</strong>
                                    <br><small class="text-muted">Includes viewport meta tag</small>
                                </div>
                                <span class="badge bg-${includeViewport ? 'success' : 'warning'}">${includeViewport ? '✓ Yes' : '⚠ Missing'}</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="validateMetaTags()">
                                Validate Tags
                            </button>
                            <button class="btn btn-outline-primary" onclick="testSocialSharing()">
                                Test Social Sharing
                            </button>
                            <button class="btn btn-outline-primary" onclick="generateMoreTags()">
                                Generate for Another Page
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 1500);
        });

        function calculateSeoScore(title, description) {
            let score = 0;

            // Title score (40 points)
            if (title.length >= 30 && title.length <= 60) score += 40;
            else if (title.length >= 20 && title.length <= 70) score += 30;
            else score += 10;

            // Description score (40 points)
            if (description.length >= 120 && description.length <= 160) score += 40;
            else if (description.length >= 100 && description.length <= 180) score += 30;
            else score += 10;

            // Additional factors (20 points)
            if (title.includes(' ')) score += 5; // Has spaces (natural language)
            if (description.includes(' ')) score += 5; // Has spaces
            if (title.length > 0) score += 5; // Has title
            if (description.length > 0) score += 5; // Has description

            return Math.min(score, 100);
        }

        function copyMetaTags() {
            const code = document.getElementById('generatedCode').textContent;
            navigator.clipboard.writeText(code).then(() => {
                alert('Meta tags copied to clipboard!');
            });
        }

        function downloadMetaTags() {
            const code = document.getElementById('generatedCode').textContent;
            const blob = new Blob([code], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'meta-tags.html';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function validateMetaTags() {
            const code = document.getElementById('generatedCode').textContent;
            const hasTitle = code.includes('<title>');
            const hasDescription = code.includes('name="description"');
            const hasCharset = code.includes('charset=');
            const hasViewport = code.includes('viewport');

            alert(`Meta Tag Validation Results:
• Title Tag: ${hasTitle ? '✓ Present' : '✗ Missing'}
• Meta Description: ${hasDescription ? '✓ Present' : '✗ Missing'}
• Charset: ${hasCharset ? '✓ Present' : '✗ Missing'}
• Viewport: ${hasViewport ? '✓ Present' : '✗ Missing'}

Overall: ${hasTitle && hasDescription ? 'Good' : 'Needs improvement'}`);
        }

        function testSocialSharing() {
            const title = document.getElementById('pageTitle').value;
            const description = document.getElementById('metaDescription').value;
            const url = document.getElementById('pageUrl').value;

            const testUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}&title=${encodeURIComponent(title)}&description=${encodeURIComponent(description)}`;
            window.open(testUrl, '_blank', 'width=600,height=400');
        }

        function generateMoreTags() {
            // Reset form for new generation
            document.getElementById('pageTitle').value = '';
            document.getElementById('metaDescription').value = '';
            document.getElementById('metaKeywords').value = '';
            document.getElementById('pageUrl').value = '';
            document.getElementById('ogImage').value = '';
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('previewSection').style.display = 'none';
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('previewSection').style.display = 'none';
        }

        // Initialize preview
        updatePreview();
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>