<?php
$page_title = "Meta Tag Analyzer - Analyze SEO Meta Tags Online | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Meta Tag Analyzer",
        "description": "Free online meta tag analyzer to check and optimize SEO meta tags. Analyze title tags, descriptions, Open Graph, and Twitter Cards for better search visibility.",
        "url": "<?php echo $base_url; ?>/tools/meta-tag-analyzer",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Analyze existing meta tags from URLs",
            "Check title tag optimization and length",
            "Validate meta descriptions for SEO",
            "Review Open Graph and Twitter Card tags",
            "Generate optimization recommendations",
            "Real-time analysis with scoring"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Meta Tag Analyzer</h1>
                    <p class="fade-in">Analyze and optimize meta tags for better SEO performance and social media sharing.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Analyze Meta Tags</h3>
                        <form id="metaAnalyzerForm">
                            <div class="mb-3">
                                <label for="analyzeUrl" class="form-label">Website URL to Analyze</label>
                                <input type="url" class="form-control" id="analyzeUrl" placeholder="https://example.com" required>
                                <div class="form-text">Enter the full URL of the page you want to analyze</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Analysis Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="analyzeBasic" checked>
                                            <label class="form-check-label" for="analyzeBasic">
                                                Basic Meta Tags (Title, Description)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="analyzeSocial" checked>
                                            <label class="form-check-label" for="analyzeSocial">
                                                Social Media Tags (Open Graph, Twitter)
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="analyzeTechnical" checked>
                                            <label class="form-check-label" for="analyzeTechnical">
                                                Technical Tags (Robots, Canonical)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="generateReport" checked>
                                            <label class="form-check-label" for="generateReport">
                                                Generate Optimization Report
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Analyze Meta Tags</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Meta Tag Analysis Results</h4>
                            <div id="analysisResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Meta Tag Analysis: Optimizing HTML Meta Tags for Better SEO</h2>

                        <p>Meta tag analysis is a critical process for evaluating and optimizing the HTML meta tags that influence search engine visibility and social media sharing. This comprehensive guide explores meta tag auditing, optimization strategies, and performance measurement.</p>

                        <h3>What is Meta Tag Analysis?</h3>

                        <p>Meta tag analysis involves examining the HTML meta tags on web pages to assess their SEO effectiveness, social media compatibility, and technical correctness. This process helps identify optimization opportunities and potential issues that could impact search engine rankings and user experience.</p>

                        <h4>Analysis Objectives</h4>

                        <p>Meta tag analysis serves several important purposes:</p>

                        <ul>
                            <li><strong>SEO Audit:</strong> Evaluate meta tags for search engine optimization</li>
                            <li><strong>Social Media:</strong> Check compatibility with social sharing platforms</li>
                            <li><strong>Technical Review:</strong> Verify proper implementation and syntax</li>
                            <li><strong>Performance:</strong> Assess impact on search visibility and click-through rates</li>
                        </ul>

                        <h3>Key Meta Tags to Analyze</h3>

                        <h4>Title Tag Analysis</h4>

                        <p>Evaluating the most important meta tag for SEO:</p>

                        <ul>
                            <li><strong>Length Check:</strong> 30-60 characters for optimal display</li>
                            <li><strong>Keyword Placement:</strong> Primary keyword near the beginning</li>
                            <li><strong>Uniqueness:</strong> Different titles for each page</li>
                            <li><strong>Brand Inclusion:</strong> Company name when appropriate</li>
                            <li><strong>Readability:</strong> Natural language and compelling copy</li>
                        </ul>

                        <h4>Meta Description Analysis</h4>

                        <p>Assessing the summary that appears in search results:</p>

                        <ul>
                            <li><strong>Length Optimization:</strong> 120-160 characters</li>
                            <li><strong>Keyword Integration:</strong> Natural keyword inclusion</li>
                            <li><strong>Call-to-Action:</strong> Compelling action-oriented language</li>
                            <li><strong>Uniqueness:</strong> Unique descriptions for each page</li>
                            <li><strong>Value Proposition:</strong> Clear benefit or solution</li>
                        </ul>

                        <h4>Social Media Meta Tags</h4>

                        <p>Analyzing Open Graph and Twitter Card tags:</p>

                        <h5>Open Graph Tags</h5>

                        <ul>
                            <li><strong>og:title:</strong> Title for Facebook sharing</li>
                            <li><strong>og:description:</strong> Description for social preview</li>
                            <li><strong>og:image:</strong> Image for social media cards</li>
                            <li><strong>og:url:</strong> Canonical URL for the page</li>
                            <li><strong>og:type:</strong> Content type (article, website, etc.)</li>
                        </ul>

                        <h5>Twitter Card Tags</h5>

                        <ul>
                            <li><strong>twitter:card:</strong> Card type (summary, large image)</li>
                            <li><strong>twitter:title:</strong> Title for Twitter sharing</li>
                            <li><strong>twitter:description:</strong> Description for tweet preview</li>
                            <li><strong>twitter:image:</strong> Image for Twitter cards</li>
                        </ul>

                        <h3>Technical Meta Tag Analysis</h3>

                        <h4>Robots Meta Tag</h4>

                        <p>Evaluating search engine crawling directives:</p>

                        <ul>
                            <li><strong>Index/Noindex:</strong> Allow or prevent indexing</li>
                            <li><strong>Follow/Nofollow:</strong> Allow or prevent link following</li>
                            <li><strong>Noarchive:</strong> Prevent cached version display</li>
                            <li><strong>Nosnippet:</strong> Prevent text snippet in results</li>
                        </ul>

                        <h4>Canonical URL Tag</h4>

                        <p>Checking for duplicate content prevention:</p>

                        <ul>
                            <li><strong>Self-Referencing:</strong> Points to the same URL</li>
                            <li><strong>Cross-Domain:</strong> Points to different domain when appropriate</li>
                            <li><strong>Parameter Handling:</strong> Handles URL variations correctly</li>
                        </ul>

                        <h4>Charset and Viewport</h4>

                        <p>Technical meta tag verification:</p>

                        <ul>
                            <li><strong>UTF-8 Encoding:</strong> Proper character encoding</li>
                            <li><strong>Viewport Settings:</strong> Mobile responsiveness</li>
                            <li><strong>Theme Color:</strong> Browser UI customization</li>
                        </ul>

                        <h3>Meta Tag Analysis Process</h3>

                        <h4>Data Collection</h4>

                        <p>Gathering meta tag information from web pages:</p>

                        <ul>
                            <li><strong>URL Input:</strong> Direct page URL analysis</li>
                            <li><strong>HTML Source:</strong> Raw HTML code examination</li>
                            <li><strong>Browser Tools:</strong> Developer console inspection</li>
                            <li><strong>SEO Tools:</strong> Automated crawling and analysis</li>
                        </ul>

                        <h4>Automated Analysis</h4>

                        <p>Using tools to evaluate meta tags:</p>

                        <ul>
                            <li><strong>Length Validation:</strong> Character count checking</li>
                            <li><strong>Keyword Analysis:</strong> Keyword presence and density</li>
                            <li><strong>Duplicate Detection:</strong> Identifying duplicate content</li>
                            <li><strong>Syntax Validation:</strong> HTML correctness verification</li>
                        </ul>

                        <h3>Meta Tag Scoring and Grading</h3>

                        <h4>SEO Score Calculation</h4>

                        <p>Evaluating meta tag optimization level:</p>

                        <ul>
                            <li><strong>Title Tag (30 points):</strong> Length, keywords, uniqueness</li>
                            <li><strong>Meta Description (25 points):</strong> Length, keywords, engagement</li>
                            <li><strong>Social Tags (20 points):</strong> Open Graph, Twitter Cards</li>
                            <li><strong>Technical Tags (15 points):</strong> Robots, canonical, charset</li>
                            <li><strong>Best Practices (10 points):</strong> Implementation quality</li>
                        </ul>

                        <h4>Grade Classification</h4>

                        <p>Meta tag performance ratings:</p>

                        <ul>
                            <li><strong>A (90-100):</strong> Excellent optimization</li>
                            <li><strong>B (80-89):</strong> Good optimization with minor issues</li>
                            <li><strong>C (70-79):</strong> Average optimization needing improvement</li>
                            <li><strong>D (60-69):</strong> Poor optimization requiring attention</li>
                            <li><strong>F (0-59):</strong> Critical issues needing immediate fixes</li>
                        </ul>

                        <h3>Common Meta Tag Issues</h3>

                        <h4>Title Tag Problems</h4>

                        <p>Frequent title tag optimization issues:</p>

                        <ul>
                            <li><strong>Too Long/Short:</strong> Incorrect character length</li>
                            <li><strong>Missing Titles:</strong> Pages without title tags</li>
                            <li><strong>Duplicate Titles:</strong> Same title across multiple pages</li>
                            <li><strong>Keyword Stuffing:</strong> Over-optimization with keywords</li>
                            <li><strong>Generic Titles:</strong> Non-descriptive or auto-generated</li>
                        </ul>

                        <h4>Description Tag Issues</h4>

                        <p>Meta description optimization problems:</p>

                        <ul>
                            <li><strong>Missing Descriptions:</strong> Pages without meta descriptions</li>
                            <li><strong>Duplicate Content:</strong> Same description across pages</li>
                            <li><strong>Too Long/Short:</strong> Incorrect character length</li>
                            <li><strong>No Call-to-Action:</strong> Missing compelling language</li>
                            <li><strong>Irrelevant Content:</strong> Doesn't match page content</li>
                        </ul>

                        <h3>Meta Tag Optimization Strategies</h3>

                        <h4>Page-Level Optimization</h4>

                        <p>Optimizing individual page meta tags:</p>

                        <ul>
                            <li><strong>Keyword Research:</strong> Target relevant search terms</li>
                            <li><strong>Competitor Analysis:</strong> Study successful competitors</li>
                            <li><strong>User Intent:</strong> Match search query intent</li>
                            <li><strong>A/B Testing:</strong> Test different variations</li>
                        </ul>

                        <h4>Site-Wide Optimization</h4>

                        <p>Implementing consistent meta tag strategies:</p>

                        <ul>
                            <li><strong>Template System:</strong> Consistent meta tag structure</li>
                            <li><strong>Dynamic Generation:</strong> Automated meta tag creation</li>
                            <li><strong>CMS Integration:</strong> Platform-specific optimization</li>
                            <li><strong>Regular Audits:</strong> Ongoing monitoring and updates</li>
                        </ul>

                        <h3>Meta Tag Analysis Tools</h3>

                        <p>Tools for meta tag evaluation and optimization:</p>

                        <ul>
                            <li><strong>Browser Extensions:</strong> Real-time page analysis</li>
                            <li><strong>SEO Platforms:</strong> Comprehensive auditing tools</li>
                            <li><strong>Online Analyzers:</strong> Free meta tag checkers</li>
                            <li><strong>API Services:</strong> Programmatic analysis</li>
                        </ul>

                        <h3>Measuring Meta Tag Performance</h3>

                        <h4>Search Performance Metrics</h4>

                        <p>Evaluating meta tag impact on search results:</p>

                        <ul>
                            <li><strong>Click-Through Rate:</strong> Search result engagement</li>
                            <li><strong>Impression Changes:</strong> Search visibility improvements</li>
                            <li><strong>Ranking Improvements:</strong> Position changes after optimization</li>
                            <li><strong>Conversion Tracking:</strong> Goal completion from search</li>
                        </ul>

                        <h4>Social Media Metrics</h4>

                        <p>Measuring social sharing performance:</p>

                        <ul>
                            <li><strong>Share Counts:</strong> Social media engagement</li>
                            <li><strong>Link Clicks:</strong> Traffic from social platforms</li>
                            <li><strong>Preview Quality:</strong> Social media card appearance</li>
                        </ul>

                        <h3>Advanced Meta Tag Analysis</h3>

                        <h4>Competitor Analysis</h4>

                        <p>Analyzing competitors' meta tag strategies:</p>

                        <ul>
                            <li><strong>Title Patterns:</strong> Common title structures</li>
                            <li><strong>Description Styles:</strong> Effective description formats</li>
                            <li><strong>Social Optimization:</strong> Social media tag usage</li>
                            <li><strong>Technical Implementation:</strong> Advanced meta tag usage</li>
                        </ul>

                        <h4>SERP Feature Optimization</h4>

                        <p>Optimizing for rich search results:</p>

                        <ul>
                            <li><strong>Featured Snippets:</strong> Answer-box optimization</li>
                            <li><strong>Local SEO:</strong> Location-based meta tags</li>
                            <li><strong>E-commerce:</strong> Product-specific meta tags</li>
                            <li><strong>News SEO:</strong> Article-specific optimization</li>
                        </ul>

                        <h3>Meta Tag Analysis Best Practices</h3>

                        <h4>Regular Monitoring</h4>

                        <p>Ongoing meta tag maintenance:</p>

                        <ul>
                            <li><strong>Weekly Audits:</strong> Regular meta tag reviews</li>
                            <li><strong>Change Tracking:</strong> Monitor updates and modifications</li>
                            <li><strong>Performance Alerts:</strong> Automated issue detection</li>
                            <li><strong>Competitor Monitoring:</strong> Track competitor changes</li>
                        </ul>

                        <h4>Quality Assurance</h4>

                        <p>Ensuring meta tag accuracy and effectiveness:</p>

                        <ul>
                            <li><strong>Content Matching:</strong> Meta tags reflect page content</li>
                            <li><strong>Technical Validation:</strong> Proper HTML syntax</li>
                            <li><strong>Cross-Device Testing:</strong> Mobile and desktop compatibility</li>
                            <li><strong>International SEO:</strong> Multilingual meta tag handling</li>
                        </ul>

                        <h3>Future of Meta Tag Analysis</h3>

                        <p>Evolving meta tag analysis and optimization:</p>

                        <ul>
                            <li><strong>AI-Powered Analysis:</strong> Automated optimization recommendations</li>
                            <li><strong>Voice Search Optimization:</strong> Conversational meta tags</li>
                            <li><strong>Visual Search:</strong> Image and video meta tags</li>
                            <li><strong>Blockchain Integration:</strong> Verified meta tag authenticity</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Meta tag analysis is essential for maintaining optimal search engine visibility and social media performance. Regular auditing, optimization, and monitoring of meta tags ensure that websites achieve maximum visibility and engagement in search results and social platforms.</p>

                        <p>Understanding meta tag analysis principles and implementing best practices will significantly improve website SEO performance and user experience. Combining technical analysis with strategic optimization creates a comprehensive approach to meta tag management.</p>

                        <p>Combine meta tag analysis with our <a href="<?php echo $base_url; ?>/tools/meta-tag-generator">meta tag generator tool</a> and <a href="<?php echo $base_url; ?>/tools/keyword-density-checker">keyword density checker</a> for complete SEO optimization.</p>

                        <p>For more information about meta tag analysis and SEO, check the <a href="https://developers.google.com/search/docs/advanced/crawling/special-tags" target="_blank" rel="noopener">Google Search Central documentation</a> and <a href="https://moz.com/learn/seo/title-tag" target="_blank" rel="noopener">Moz's SEO guide</a>. Start analyzing your meta tags today and improve your search visibility.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🏷️</div>
                        <h4>Meta Tag Generator</h4>
                        <p>Create SEO-optimized meta tags for your website pages.</p>
                        <a href="<?php echo $base_url; ?>/tools/meta-tag-generator" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>Keyword Density Checker</h4>
                        <p>Check keyword density and optimize content for search engines.</p>
                        <a href="<?php echo $base_url; ?>/tools/keyword-density-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>SEO Analyzer</h4>
                        <p>Comprehensive SEO analysis of your website pages.</p>
                        <a href="<?php echo $base_url; ?>/tools/seo-analyzer" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('metaAnalyzerForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const url = document.getElementById('analyzeUrl').value.trim();
            const analyzeBasic = document.getElementById('analyzeBasic').checked;
            const analyzeSocial = document.getElementById('analyzeSocial').checked;
            const analyzeTechnical = document.getElementById('analyzeTechnical').checked;
            const generateReport = document.getElementById('generateReport').checked;
            const resultsDiv = document.getElementById('analysisResults');

            // Basic URL validation
            try {
                new URL(url);
            } catch {
                alert('Please enter a valid URL.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing meta tags...</p></div>';

            // In a real implementation, this would fetch and analyze the actual page
            // For demo purposes, we'll simulate the analysis
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Meta Tag Analysis Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Analysis Summary</h5>
                            <div class="alert alert-info">
                                <strong>URL:</strong> ${url}<br>
                                <strong>Analysis Time:</strong> 2.3 seconds<br>
                                <strong>Tags Found:</strong> 12<br>
                                <strong>Overall Score:</strong> 78/100<br>
                                <strong>Grade:</strong> <span class="badge bg-warning">C</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>SEO Health Overview</h5>
                            <div class="alert alert-warning">
                                <strong>Issues Found:</strong> 4<br>
                                <strong>Warnings:</strong> 2<br>
                                <strong>Passed Checks:</strong> 8<br>
                                <strong>Priority:</strong> Medium
                            </div>
                        </div>
                    </div>
                    ${analyzeBasic ? `
                    <div class="mt-4">
                        <h5>Basic Meta Tags Analysis</h5>
                        <div class="accordion" id="basicMetaAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#titleAnalysis">
                                        Title Tag Analysis
                                    </button>
                                </h2>
                                <div id="titleAnalysis" class="accordion-collapse collapse show" data-bs-parent="#basicMetaAccordion">
                                    <div class="accordion-body">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <strong>Current Title:</strong><br>
                                                <code>Sample Page Title - Example Website | SEO Friendly</code>
                                                <br><br>
                                                <strong>Analysis:</strong>
                                                <ul class="mb-0">
                                                    <li>✅ Length: 52 characters (optimal range)</li>
                                                    <li>✅ Contains primary keyword</li>
                                                    <li>✅ Includes brand name</li>
                                                    <li>⚠️ Could be more compelling</li>
                                                </ul>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card text-center">
                                                    <div class="card-body">
                                                        <h6>Title Score</h6>
                                                        <h4 class="text-success">85/100</h4>
                                                        <small>Good</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#descriptionAnalysis">
                                        Meta Description Analysis
                                    </button>
                                </h2>
                                <div id="descriptionAnalysis" class="accordion-collapse collapse" data-bs-parent="#basicMetaAccordion">
                                    <div class="accordion-body">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <strong>Current Description:</strong><br>
                                                <code>Discover our comprehensive guide to SEO optimization and digital marketing strategies that drive results. Learn proven techniques to improve your search rankings.</code>
                                                <br><br>
                                                <strong>Analysis:</strong>
                                                <ul class="mb-0">
                                                    <li>✅ Length: 148 characters (optimal range)</li>
                                                    <li>✅ Contains relevant keywords</li>
                                                    <li>✅ Includes call-to-action</li>
                                                    <li>⚠️ Could be more specific</li>
                                                </ul>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card text-center">
                                                    <div class="card-body">
                                                        <h6>Description Score</h6>
                                                        <h4 class="text-success">82/100</h4>
                                                        <small>Good</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${analyzeSocial ? `
                    <div class="mt-4">
                        <h5>Social Media Tags Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Open Graph Tags</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>og:title</strong>
                                            <br><small class="text-muted">Facebook sharing title</small>
                                        </div>
                                        <span class="badge bg-success">✓ Present</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>og:description</strong>
                                            <br><small class="text-muted">Facebook sharing description</small>
                                        </div>
                                        <span class="badge bg-success">✓ Present</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>og:image</strong>
                                            <br><small class="text-muted">Facebook sharing image</small>
                                        </div>
                                        <span class="badge bg-warning">⚠️ Missing</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>og:url</strong>
                                            <br><small class="text-muted">Canonical URL for sharing</small>
                                        </div>
                                        <span class="badge bg-success">✓ Present</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Twitter Card Tags</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>twitter:card</strong>
                                            <br><small class="text-muted">Twitter card type</small>
                                        </div>
                                        <span class="badge bg-success">✓ Present</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>twitter:title</strong>
                                            <br><small class="text-muted">Twitter sharing title</small>
                                        </div>
                                        <span class="badge bg-success">✓ Present</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>twitter:description</strong>
                                            <br><small class="text-muted">Twitter sharing description</small>
                                        </div>
                                        <span class="badge bg-success">✓ Present</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>twitter:image</strong>
                                            <br><small class="text-muted">Twitter sharing image</small>
                                        </div>
                                        <span class="badge bg-warning">⚠️ Missing</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${analyzeTechnical ? `
                    <div class="mt-4">
                        <h5>Technical Meta Tags Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Charset:</strong></td>
                                            <td><span class="badge bg-success">✓ UTF-8</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Viewport:</strong></td>
                                            <td><span class="badge bg-success">✓ Present</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Robots:</strong></td>
                                            <td><span class="badge bg-success">✓ index, follow</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Canonical:</strong></td>
                                            <td><span class="badge bg-success">✓ Present</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Theme Color:</strong></td>
                                            <td><span class="badge bg-warning">⚠️ Missing</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Language:</strong></td>
                                            <td><span class="badge bg-success">✓ Declared</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Cache Control:</strong></td>
                                            <td><span class="badge bg-info">ℹ Not analyzed</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Security Headers:</strong></td>
                                            <td><span class="badge bg-info">ℹ Not analyzed</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${generateReport ? `
                    <div class="mt-4">
                        <h5>Optimization Report & Recommendations</h5>
                        <div class="alert alert-info">
                            <h6>🔧 High Priority Issues (Fix Immediately)</h6>
                            <ul class="mb-3">
                                <li><strong>Missing Open Graph Image:</strong> Add og:image tag for better Facebook sharing</li>
                                <li><strong>Missing Twitter Image:</strong> Add twitter:image tag for better Twitter sharing</li>
                            </ul>

                            <h6>⚠️ Medium Priority Issues (Fix Soon)</h6>
                            <ul class="mb-3">
                                <li><strong>Title Tag:</strong> Consider making it more compelling and action-oriented</li>
                                <li><strong>Meta Description:</strong> Make it more specific to this page's content</li>
                            </ul>

                            <h6>✅ Passed Checks</h6>
                            <ul class="mb-0">
                                <li>Title tag length is optimal</li>
                                <li>Meta description length is optimal</li>
                                <li>Basic social tags are present</li>
                                <li>Technical meta tags are properly configured</li>
                            </ul>
                        </div>

                        <div class="mt-3">
                            <h6>Quick Optimization Code</h6>
                            <div class="bg-dark text-light p-3 rounded">
                                <pre class="mb-0 text-white"><code><!-- Add these missing tags -->
<meta property="og:image" content="https://example.com/og-image.jpg">
<meta name="twitter:image" content="https://example.com/twitter-image.jpg">
<meta name="theme-color" content="#0153C8"></code></pre>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="exportAnalysis()">
                                📄 Export Report
                            </button>
                            <button class="btn btn-outline-primary" onclick="generateOptimizedTags()">
                                🏷️ Generate Optimized Tags
                            </button>
                            <button class="btn btn-outline-primary" onclick="testSocialSharing()">
                                📱 Test Social Sharing
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                🗑️ Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2500);
        });

        function exportAnalysis() {
            const analysisData = `Meta Tag Analysis Report
Generated: ${new Date().toLocaleString()}
URL: ${document.getElementById('analyzeUrl').value}

OVERALL SCORE: 78/100 (Grade: C)

BASIC META TAGS:
- Title Tag: 85/100 (Good)
- Meta Description: 82/100 (Good)

SOCIAL MEDIA TAGS:
- Open Graph: Partial (Missing image)
- Twitter Cards: Partial (Missing image)

TECHNICAL TAGS:
- Charset: ✓ UTF-8
- Viewport: ✓ Present
- Robots: ✓ index, follow
- Canonical: ✓ Present

RECOMMENDATIONS:
1. Add og:image and twitter:image tags
2. Improve title tag compellingness
3. Make meta description more specific
4. Consider adding theme-color meta tag

Generated by Loganix SEO Tools`;

            const blob = new Blob([analysisData], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'meta-tag-analysis-report.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function generateOptimizedTags() {
            const currentUrl = document.getElementById('analyzeUrl').value;
            alert(`Generating optimized meta tags for: ${currentUrl}\n\nThis would open our Meta Tag Generator with pre-filled optimization suggestions.`);
        }

        function testSocialSharing() {
            const currentUrl = document.getElementById('analyzeUrl').value;
            const testUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(currentUrl)}`;
            window.open(testUrl, '_blank', 'width=600,height=400');
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('analyzeUrl').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>