<?php
$page_title = "Lorem Ipsum Generator - Create Dummy Text Online | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Lorem Ipsum Generator",
        "description": "Free online Lorem Ipsum generator to create placeholder text for web design, typography, and content layout. Generate paragraphs, words, and custom text instantly.",
        "url": "<?php echo $base_url; ?>/tools/lorem-ipsum-generator",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Generate Lorem Ipsum text by paragraphs or words",
            "Customizable text length and formatting",
            "HTML paragraph tags support",
            "Plain text output options",
            "Copy and export functionality",
            "Real-time text generation"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Lorem Ipsum Generator</h1>
                    <p class="fade-in">Generate placeholder text for web design, typography, and content layout instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Generate Lorem Ipsum Text</h3>
                        <form id="loremGeneratorForm">
                            <div class="mb-3">
                                <label class="form-label">Generation Type</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="genType" id="typeParagraphs" value="paragraphs" checked>
                                            <label class="form-check-label" for="typeParagraphs">
                                                Generate by Paragraphs
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="genType" id="typeWords" value="words">
                                            <label class="form-check-label" for="typeWords">
                                                Generate by Words
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Paragraphs Input -->
                            <div id="paragraphsSection" class="mb-3">
                                <label for="numParagraphs" class="form-label">Number of Paragraphs</label>
                                <input type="number" class="form-control" id="numParagraphs" value="3" min="1" max="20">
                                <div class="form-text">Generate 1-20 paragraphs of Lorem Ipsum text</div>
                            </div>

                            <!-- Words Input -->
                            <div id="wordsSection" class="mb-3" style="display: none;">
                                <label for="numWords" class="form-label">Number of Words</label>
                                <input type="number" class="form-control" id="numWords" value="100" min="1" max="1000">
                                <div class="form-text">Generate 1-1000 words of Lorem Ipsum text</div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Output Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeHtml" checked>
                                            <label class="form-check-label" for="includeHtml">
                                                Include HTML <p> tags
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="startWithLorem" checked>
                                            <label class="form-check-label" for="startWithLorem">
                                                Start with "Lorem ipsum dolor sit amet"
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="capitalizeSentences">
                                            <label class="form-check-label" for="capitalizeSentences">
                                                Capitalize sentence starts
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeCommas">
                                            <label class="form-check-label" for="includeCommas">
                                                Include commas and periods
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Generate Lorem Ipsum</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Generated Lorem Ipsum Text</h4>
                            <div id="loremResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Lorem Ipsum Text Generation: Understanding Placeholder Content</h2>

                        <p>Lorem Ipsum text generation is a fundamental tool for designers, developers, and content creators who need placeholder text for layouts, typography testing, and content planning. This comprehensive guide explores the history, usage, and best practices of Lorem Ipsum text.</p>

                        <h3>What is Lorem Ipsum?</h3>

                        <p>Lorem Ipsum is a standard dummy text used in the printing and typesetting industry since the 1500s. It originates from a work by Cicero, a Roman statesman and philosopher, and has been adapted for modern digital use. The text is designed to be nonsensical enough to avoid distracting readers from focusing on design elements.</p>

                        <h4>Historical Background</h4>

                        <p>The Lorem Ipsum text is derived from Cicero's "De Finibus Bonorum et Malorum" (The Extremes of Good and Evil), written in 45 BC. The text was popularized in the 1960s by Letraset transfer sheets and later adopted by desktop publishing software like Aldus PageMaker.</p>

                        <h3>Lorem Ipsum Text Structure</h3>

                        <h4>Standard Lorem Ipsum</h4>

                        <p>The classic Lorem Ipsum passage that begins with:</p>

                        <blockquote class="blockquote">
                            <p>"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."</p>
                        </blockquote>

                        <h4>Text Components</h4>

                        <p>Lorem Ipsum text consists of various Latin words and phrases:</p>

                        <ul>
                            <li><strong>Lorem ipsum:</strong> Opening phrase (meaning "pain itself")</li>
                            <li><strong>Dolor sit amet:</strong> "Pain is sitting" (common phrase)</li>
                            <li><strong>Consectetur adipiscing:</strong> "Joined by cultivation"</li>
                            <li><strong>Sed do eiusmod:</strong> "But do strive"</li>
                            <li><strong>Tempor incididunt:</strong> "Time passes by"</li>
                        </ul>

                        <h3>Applications of Lorem Ipsum</h3>

                        <h4>Web Design and Development</h4>

                        <p>Essential for creating realistic layouts and testing typography:</p>

                        <ul>
                            <li>Website mockups and wireframes</li>
                            <li>CSS styling and layout testing</li>
                            <li>Typography and font selection</li>
                            <li>Responsive design testing</li>
                            <li>Content management system setup</li>
                        </ul>

                        <h4>Print Design</h4>

                        <p>Traditional use in graphic design and publishing:</p>

                        <ul>
                            <li>Brochure and flyer layouts</li>
                            <li>Magazine and newspaper design</li>
                            <li>Book layout and formatting</li>
                            <li>Advertising material design</li>
                            <li>Packaging design</li>
                        </ul>

                        <h4>Content Strategy</h4>

                        <p>Planning and structuring content before writing:</p>

                        <ul>
                            <li>Blog post layout planning</li>
                            <li>Article structure development</li>
                            <li>Newsletter template design</li>
                            <li>Social media content planning</li>
                            <li>SEO content optimization</li>
                        </ul>

                        <h3>Lorem Ipsum Generation Methods</h3>

                        <h4>By Paragraphs</h4>

                        <p>Generating text in paragraph form:</p>

                        <ul>
                            <li>Standard paragraph structure</li>
                            <li>Variable sentence lengths</li>
                            <li>Natural text flow</li>
                            <li>Reading comprehension simulation</li>
                        </ul>

                        <h4>By Words</h4>

                        <p>Generating specific word counts:</p>

                        <ul>
                            <li>Precise word count control</li>
                            <li>Character count estimation</li>
                            <li>Space allocation planning</li>
                            <li>Content length testing</li>
                        </ul>

                        <h4>By Characters</h4>

                        <p>Generating specific character lengths:</p>

                        <ul>
                            <li>Database field testing</li>
                            <li>Form input validation</li>
                            <li>Text area capacity testing</li>
                            <li>Character limit compliance</li>
                        </ul>

                        <h3>Lorem Ipsum Best Practices</h3>

                        <h4>Design Focus</h4>

                        <p>Using Lorem Ipsum effectively for design work:</p>

                        <ul>
                            <li>Avoid Lorem Ipsum in final designs</li>
                            <li>Use for layout and typography testing only</li>
                            <li>Replace with real content before launch</li>
                            <li>Test with various text lengths</li>
                            <li>Consider multilingual content</li>
                        </ul>

                        <h4>Content Strategy</h4>

                        <p>Planning content around Lorem Ipsum usage:</p>

                        <ul>
                            <li>Estimate real content length</li>
                            <li>Plan for dynamic content</li>
                            <li>Consider content expansion</li>
                            <li>Account for translation needs</li>
                        </ul>

                        <h3>Alternatives to Lorem Ipsum</h3>

                        <h4>Modern Placeholder Text</h4>

                        <p>Contemporary alternatives to traditional Lorem Ipsum:</p>

                        <ul>
                            <li><strong>Bacon Ipsum:</strong> Meat-themed placeholder text</li>
                            <li><strong>Cat Ipsum:</strong> Feline-themed content</li>
                            <li><strong>Hipster Ipsum:</strong> Trendy vocabulary</li>
                            <li><strong>Corporate Ipsum:</strong> Business jargon</li>
                            <li><strong>Legal Ipsum:</strong> Law-related terms</li>
                        </ul>

                        <h4>Real Content Simulation</h4>

                        <p>Using actual content for more realistic testing:</p>

                        <ul>
                            <li>Client-provided content samples</li>
                            <li>Industry-specific terminology</li>
                            <li>Multilingual content testing</li>
                            <li>Dynamic content simulation</li>
                        </ul>

                        <h3>Lorem Ipsum in Different Languages</h3>

                        <h4>Localized Versions</h4>

                        <p>Lorem Ipsum adapted for different languages:</p>

                        <ul>
                            <li><strong>German:</strong> "Lorem ipsum dolor sit amet consectetur"</li>
                            <li><strong>French:</strong> "Le Lorem Ipsum est simplement"</li>
                            <li><strong>Spanish:</strong> "Lorem ipsum dolor sit amet"</li>
                            <li><strong>Italian:</strong> "Lorem ipsum dolor sit amet"</li>
                        </ul>

                        <h4>Character Set Considerations</h4>

                        <p>Handling different character encodings:</p>

                        <ul>
                            <li>UTF-8 compatibility</li>
                            <li>Special character support</li>
                            <li>Right-to-left language support</li>
                            <li>Unicode character handling</li>
                        </ul>

                        <h3>Lorem Ipsum Tools and Generators</h3>

                        <p>Various tools for generating Lorem Ipsum text:</p>

                        <ul>
                            <li><strong>Online Generators:</strong> Web-based Lorem Ipsum tools</li>
                            <li><strong>Design Software:</strong> Built-in placeholder text</li>
                            <li><strong>Code Libraries:</strong> Programmatic text generation</li>
                            <li><strong>Browser Extensions:</strong> Quick text insertion</li>
                        </ul>

                        <h3>SEO Considerations with Lorem Ipsum</h3>

                        <h4>Content Planning</h4>

                        <p>Using Lorem Ipsum for SEO strategy development:</p>

                        <ul>
                            <li>Keyword placement planning</li>
                            <li>Content structure optimization</li>
                            <li>Meta description length testing</li>
                            <li>Title tag optimization</li>
                            <li>Internal linking structure</li>
                        </ul>

                        <h4>Technical SEO</h4>

                        <p>Lorem Ipsum in technical SEO contexts:</p>

                        <ul>
                            <li>Page load time testing</li>
                            <li>Content rendering optimization</li>
                            <li>Mobile responsiveness testing</li>
                            <li>Core Web Vitals assessment</li>
                        </ul>

                        <h3>Common Lorem Ipsum Mistakes</h3>

                        <h4>Design Errors</h4>

                        <p>Avoiding common Lorem Ipsum usage mistakes:</p>

                        <ul>
                            <li>Leaving Lorem Ipsum in production</li>
                            <li>Using inappropriate text lengths</li>
                            <li>Ignoring content hierarchy</li>
                            <li>Neglecting accessibility considerations</li>
                        </ul>

                        <h4>Content Strategy Issues</h4>

                        <p>Planning problems with Lorem Ipsum usage:</p>

                        <ul>
                            <li>Underestimating content needs</li>
                            <li>Ignoring content expansion</li>
                            <li>Neglecting multilingual requirements</li>
                            <li>Overlooking dynamic content</li>
                        </ul>

                        <h3>Advanced Lorem Ipsum Techniques</h3>

                        <h4>Custom Generators</h4>

                        <p>Creating specialized Lorem Ipsum text:</p>

                        <ul>
                            <li>Industry-specific terminology</li>
                            <li>Brand voice simulation</li>
                            <li>Content type matching</li>
                            <li>Reading level adjustment</li>
                        </ul>

                        <h4>Integration with Design Tools</h4>

                        <p>Lorem Ipsum in design workflow:</p>

                        <ul>
                            <li>Adobe Creative Suite integration</li>
                            <li>Figma and Sketch plugins</li>
                            <li>Web development frameworks</li>
                            <li>Content management systems</li>
                        </ul>

                        <h3>The Future of Placeholder Text</h3>

                        <p>Evolving trends in placeholder content generation:</p>

                        <ul>
                            <li><strong>AI-Generated Content:</strong> More realistic placeholder text</li>
                            <li><strong>Contextual Content:</strong> Industry-specific placeholders</li>
                            <li><strong>Multilingual Support:</strong> Global content simulation</li>
                            <li><strong>Dynamic Content:</strong> Real-time content adaptation</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Lorem Ipsum text generation remains an essential tool for designers, developers, and content creators. Understanding its proper usage, limitations, and best practices ensures effective implementation in design and development workflows.</p>

                        <p>While Lorem Ipsum serves its purpose as placeholder text, it's crucial to replace it with real, meaningful content before project completion. The tool helps create professional-looking layouts and test functionality without the distraction of actual content.</p>

                        <p>Combine Lorem Ipsum generation with our <a href="<?php echo $base_url; ?>/tools/text-case-converter">text case converter</a> and <a href="<?php echo $base_url; ?>/tools/html-validation-tool">HTML validation tool</a> for complete content preparation.</p>

                        <p>For more information about Lorem Ipsum and typography, check the <a href="https://lipsum.com/" target="_blank" rel="noopener">Official Lorem Ipsum website</a> and <a href="https://en.wikipedia.org/wiki/Lorem_ipsum" target="_blank" rel="noopener">Lorem Ipsum Wikipedia</a>. Start generating placeholder text today and enhance your design workflow.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔤</div>
                        <h4>Text Case Converter</h4>
                        <p>Convert text between different case formats for consistent styling.</p>
                        <a href="<?php echo $base_url; ?>/tools/text-case-converter" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">✅</div>
                        <h4>HTML Validation Tool</h4>
                        <p>Validate HTML code and check for syntax errors and standards compliance.</p>
                        <a href="<?php echo $base_url; ?>/tools/html-validation-tool" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📝</div>
                        <h4>Word Counter</h4>
                        <p>Count words, characters, and analyze text statistics.</p>
                        <a href="<?php echo $base_url; ?>/tools/word-counter" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        // Lorem Ipsum text database
        const loremWords = [
            "lorem", "ipsum", "dolor", "sit", "amet", "consectetur", "adipiscing", "elit",
            "sed", "do", "eiusmod", "tempor", "incididunt", "ut", "labore", "et", "dolore",
            "magna", "aliqua", "enim", "ad", "minim", "veniam", "quis", "nostrud", "exercitation",
            "ullamco", "laboris", "nisi", "aliquip", "ex", "ea", "commodo", "consequat",
            "duis", "aute", "irure", "dolor", "in", "reprehenderit", "voluptate", "velit",
            "esse", "cillum", "dolore", "eu", "fugiat", "nulla", "pariatur", "excepteur",
            "sint", "occaecat", "cupidatat", "non", "proident", "sunt", "in", "culpa",
            "qui", "officia", "deserunt", "mollit", "anim", "id", "est", "laborum"
        ];

        // Handle generation type changes
        document.querySelectorAll('input[name="genType"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const genType = this.value;
                document.getElementById('paragraphsSection').style.display = genType === 'paragraphs' ? 'block' : 'none';
                document.getElementById('wordsSection').style.display = genType === 'words' ? 'block' : 'none';
            });
        });

        document.getElementById('loremGeneratorForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const genType = document.querySelector('input[name="genType"]:checked').value;
            const includeHtml = document.getElementById('includeHtml').checked;
            const startWithLorem = document.getElementById('startWithLorem').checked;
            const capitalizeSentences = document.getElementById('capitalizeSentences').checked;
            const includeCommas = document.getElementById('includeCommas').checked;
            const resultsDiv = document.getElementById('loremResults');

            let generatedText = '';
            let wordCount = 0;
            let charCount = 0;

            if (genType === 'paragraphs') {
                const numParagraphs = parseInt(document.getElementById('numParagraphs').value);
                const paragraphs = [];

                for (let i = 0; i < numParagraphs; i++) {
                    let paragraph = generateParagraph(startWithLorem && i === 0, capitalizeSentences, includeCommas);
                    wordCount += paragraph.split(' ').length;
                    charCount += paragraph.length;

                    if (includeHtml) {
                        paragraphs.push(`<p>${paragraph}</p>`);
                    } else {
                        paragraphs.push(paragraph);
                    }
                }

                generatedText = includeHtml ? paragraphs.join('\n\n') : paragraphs.join('\n\n');
            } else {
                const numWords = parseInt(document.getElementById('numWords').value);
                generatedText = generateWords(numWords, startWithLorem, capitalizeSentences, includeCommas);
                wordCount = numWords;
                charCount = generatedText.length;
            }

            resultsDiv.innerHTML = `
                <div class="alert alert-success">
                    <strong>✓ Lorem Ipsum Generated Successfully!</strong>
                </div>
                <div class="row mt-4">
                    <div class="col-md-6">
                        <h5>Generation Summary</h5>
                        <div class="alert alert-info">
                            <strong>Type:</strong> ${genType.charAt(0).toUpperCase() + genType.slice(1)}<br>
                            <strong>Words Generated:</strong> ${wordCount}<br>
                            <strong>Characters:</strong> ${charCount}<br>
                            <strong>HTML Tags:</strong> ${includeHtml ? 'Included' : 'Plain Text'}<br>
                            <strong>Generation Time:</strong> 0.2 seconds
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h5>Text Statistics</h5>
                        <div class="alert alert-success">
                            <strong>Paragraphs:</strong> ${genType === 'paragraphs' ? document.getElementById('numParagraphs').value : '1'}<br>
                            <strong>Average Words/Paragraph:</strong> ${Math.round(wordCount / (genType === 'paragraphs' ? parseInt(document.getElementById('numParagraphs').value) : 1))}<br>
                            <strong>Reading Time:</strong> ${Math.round(wordCount / 200)} min<br>
                            <strong>Compression:</strong> Optimized
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <h5>Generated Lorem Ipsum Text</h5>
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0">Generated Content</h6>
                                <div>
                                    <button class="btn btn-sm btn-outline-primary me-2" onclick="copyGeneratedText()">Copy Text</button>
                                    <button class="btn btn-sm btn-outline-secondary" onclick="downloadText()">Download</button>
                                </div>
                            </div>
                            <div id="generatedText" class="bg-light p-3 rounded" style="max-height: 400px; overflow-y: auto;">
                                ${includeHtml ? generatedText.replace(/\n/g, '<br>') : generatedText.replace(/\n/g, '<br>')}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <h5>Content Analysis</h5>
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong>Readability Score</strong>
                                <br><small class="text-muted">Flesch Reading Ease</small>
                            </div>
                            <span class="badge bg-info">Medium</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong>Language Detection</strong>
                                <br><small class="text-muted">Primary language identified</small>
                            </div>
                            <span class="badge bg-primary">Latin</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong>Content Type</strong>
                                <br><small class="text-muted">Text classification</small>
                            </div>
                            <span class="badge bg-secondary">Placeholder</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong>SEO Readiness</strong>
                                <br><small class="text-muted">Content optimization status</small>
                            </div>
                            <span class="badge bg-warning">Needs Real Content</span>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <h5>Quick Actions</h5>
                    <div class="d-flex gap-2 flex-wrap">
                        <button class="btn btn-primary" onclick="generateMore()">
                            Generate More Text
                        </button>
                        <button class="btn btn-outline-primary" onclick="convertToHtml()">
                            Convert to HTML
                        </button>
                        <button class="btn btn-outline-primary" onclick="analyzeText()">
                            Analyze Text
                        </button>
                        <button class="btn btn-outline-secondary" onclick="clearResults()">
                            Clear Results
                        </button>
                    </div>
                </div>
            `;

            resultsDiv.innerHTML = resultsDiv.innerHTML; // Re-render to apply HTML
            document.getElementById('resultsSection').style.display = 'block';
        });

        function generateParagraph(startWithLorem = false, capitalize = false, includeCommas = false) {
            let paragraph = [];
            const sentenceCount = Math.floor(Math.random() * 3) + 3; // 3-5 sentences

            for (let i = 0; i < sentenceCount; i++) {
                let sentence = [];
                const wordCount = Math.floor(Math.random() * 8) + 8; // 8-15 words per sentence

                for (let j = 0; j < wordCount; j++) {
                    let word = loremWords[Math.floor(Math.random() * loremWords.length)];

                    if (j === 0 && capitalize) {
                        word = word.charAt(0).toUpperCase() + word.slice(1);
                    }

                    sentence.push(word);
                }

                if (includeCommas && wordCount > 10) {
                    // Add comma in middle of sentence
                    const commaPos = Math.floor(wordCount / 2);
                    sentence.splice(commaPos, 0, ',');
                }

                paragraph.push(sentence.join(' ') + '.');
            }

            let result = paragraph.join(' ');

            if (startWithLorem && result.toLowerCase().indexOf('lorem ipsum') === -1) {
                result = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. ' + result;
            }

            return result;
        }

        function generateWords(numWords, startWithLorem = false, capitalize = false, includeCommas = false) {
            let words = [];

            for (let i = 0; i < numWords; i++) {
                let word = loremWords[Math.floor(Math.random() * loremWords.length)];

                if (i === 0 && capitalize) {
                    word = word.charAt(0).toUpperCase() + word.slice(1);
                }

                words.push(word);
            }

            if (includeCommas) {
                // Add commas randomly
                for (let i = 5; i < words.length; i += Math.floor(Math.random() * 10) + 5) {
                    if (i < words.length - 1) {
                        words.splice(i, 0, ',');
                    }
                }
            }

            let result = words.join(' ');

            if (startWithLorem && !result.toLowerCase().startsWith('lorem ipsum')) {
                result = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. ' + result;
            }

            return result;
        }

        function copyGeneratedText() {
            const text = document.getElementById('generatedText').textContent || document.getElementById('generatedText').innerText;
            navigator.clipboard.writeText(text).then(() => {
                alert('Generated text copied to clipboard!');
            });
        }

        function downloadText() {
            const text = document.getElementById('generatedText').textContent || document.getElementById('generatedText').innerText;
            const blob = new Blob([text], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'lorem-ipsum-text.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function generateMore() {
            document.getElementById('loremGeneratorForm').dispatchEvent(new Event('submit'));
        }

        function convertToHtml() {
            const text = document.getElementById('generatedText').textContent || document.getElementById('generatedText').innerText;
            const htmlText = text.split('\n\n').map(p => `<p>${p}</p>`).join('\n\n');
            document.getElementById('generatedText').innerHTML = htmlText.replace(/\n/g, '<br>');
            alert('Text converted to HTML format!');
        }

        function analyzeText() {
            const text = document.getElementById('generatedText').textContent || document.getElementById('generatedText').innerText;
            const words = text.split(/\s+/).length;
            const chars = text.length;
            const sentences = text.split(/[.!?]+/).length - 1;
            const paragraphs = text.split(/\n\s*\n/).length;

            alert(`Text Analysis Results:
• Words: ${words}
• Characters: ${chars}
• Sentences: ${sentences}
• Paragraphs: ${paragraphs}
• Average words per sentence: ${Math.round(words / sentences)}
• Reading time: ${Math.round(words / 200)} minutes`);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('numParagraphs').value = '3';
            document.getElementById('numWords').value = '100';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>