<?php
$page_title = "Keyword Density Checker - Analyze SEO Keyword Usage | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Keyword Density Checker",
        "description": "Free online keyword density checker to analyze keyword usage in content. Check keyword frequency, density percentage, and optimize content for better SEO performance.",
        "url": "<?php echo $base_url; ?>/tools/keyword-density-checker",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Analyze keyword density and frequency in content",
            "Check single and multi-word keyword phrases",
            "Real-time density calculation and recommendations",
            "Content optimization suggestions",
            "Export keyword analysis reports",
            "SEO scoring and best practices"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Keyword Density Checker</h1>
                    <p class="fade-in">Analyze keyword usage and density in your content for optimal SEO performance.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Check Keyword Density</h3>
                        <form id="densityCheckerForm">
                            <div class="mb-3">
                                <label for="contentText" class="form-label">Content Text</label>
                                <textarea class="form-control" id="contentText" rows="8" placeholder="Paste your content here to analyze keyword density..." required></textarea>
                                <div class="form-text">Enter or paste the content you want to analyze (minimum 100 words recommended)</div>
                            </div>
                            <div class="mb-3">
                                <label for="primaryKeyword" class="form-label">Primary Keyword</label>
                                <input type="text" class="form-control" id="primaryKeyword" placeholder="Enter your main keyword or phrase">
                                <div class="form-text">Your main target keyword or keyphrase</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Analysis Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="analyzeSingleWords" checked>
                                            <label class="form-check-label" for="analyzeSingleWords">
                                                Analyze single word keywords
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="analyzePhrases" checked>
                                            <label class="form-check-label" for="analyzePhrases">
                                                Analyze keyword phrases (2-3 words)
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="includeStopWords" checked>
                                            <label class="form-check-label" for="includeStopWords">
                                                Include common stop words
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="caseSensitive" checked>
                                            <label class="form-check-label" for="caseSensitive">
                                                Case-sensitive analysis
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Analyze Keyword Density</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Keyword Density Analysis Results</h4>
                            <div id="densityResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Keyword Density Analysis: Optimizing Content for Search Engines</h2>

                        <p>Keyword density analysis is a fundamental SEO technique that measures how frequently specific keywords appear in content relative to the total word count. This comprehensive guide explores keyword density concepts, analysis methods, and optimization strategies for better search engine rankings.</p>

                        <h3>What is Keyword Density?</h3>

                        <p>Keyword density, also known as keyword frequency, is the percentage of times a specific keyword or phrase appears in a piece of content compared to the total number of words. It's calculated by dividing the number of keyword occurrences by the total word count and multiplying by 100.</p>

                        <h4>Density Formula</h4>

                        <p>The basic keyword density calculation:</p>

                        <pre><code>Keyword Density = (Number of Keyword Occurrences ÷ Total Words) × 100</code></pre>

                        <h4>Example Calculation</h4>

                        <p>For a 500-word article with "SEO optimization" appearing 8 times:</p>

                        <pre><code>Density = (8 ÷ 500) × 100 = 1.6%</code></pre>

                        <h3>Types of Keywords to Analyze</h3>

                        <h4>Primary Keywords</h4>

                        <p>The main target keywords for a piece of content:</p>

                        <ul>
                            <li><strong>Head Keyword:</strong> Main topic keyword</li>
                            <li><strong>Long-tail Keywords:</strong> Specific phrase variations</li>
                            <li><strong>LSI Keywords:</strong> Semantically related terms</li>
                            <li><strong>Question Keywords:</strong> Query-based phrases</li>
                        </ul>

                        <h4>Secondary Keywords</h4>

                        <p>Supporting keywords that enhance topic relevance:</p>

                        <ul>
                            <li><strong>Related Terms:</strong> Topic-related vocabulary</li>
                            <li><strong>Synonyms:</strong> Alternative word choices</li>
                            <li><strong>Variations:</strong> Different forms of keywords</li>
                            <li><strong>Supporting Phrases:</strong> Contextual keyword combinations</li>
                        </ul>

                        <h3>Optimal Keyword Density Ranges</h3>

                        <h4>Primary Keywords</h4>

                        <p>Recommended density ranges for main target keywords:</p>

                        <ul>
                            <li><strong>Short-tail Keywords:</strong> 0.5% - 2.0%</li>
                            <li><strong>Long-tail Keywords:</strong> 1.0% - 3.0%</li>
                            <li><strong>LSI Keywords:</strong> 0.2% - 1.5%</li>
                            <li><strong>Brand Terms:</strong> 0.3% - 1.0%</li>
                        </ul>

                        <h4>Content Length Considerations</h4>

                        <p>Density recommendations vary by content length:</p>

                        <ul>
                            <li><strong>Short Content (300-500 words):</strong> 1.5% - 3.0%</li>
                            <li><strong>Medium Content (500-1000 words):</strong> 1.0% - 2.5%</li>
                            <li><strong>Long Content (1000+ words):</strong> 0.8% - 2.0%</li>
                            <li><strong>Blog Posts:</strong> 1.0% - 2.5%</li>
                            <li><strong>Landing Pages:</strong> 2.0% - 4.0%</li>
                        </ul>

                        <h3>Keyword Density Analysis Process</h3>

                        <h4>Content Preparation</h4>

                        <p>Steps to prepare content for density analysis:</p>

                        <ul>
                            <li><strong>Text Extraction:</strong> Remove HTML and formatting</li>
                            <li><strong>Stop Word Filtering:</strong> Remove common words (the, and, or)</li>
                            <li><strong>Stemming:</strong> Reduce words to root forms</li>
                            <li><strong>Case Normalization:</strong> Convert to lowercase</li>
                        </ul>

                        <h4>Density Calculation</h4>

                        <p>Methods for calculating keyword density:</p>

                        <ul>
                            <li><strong>Simple Frequency:</strong> Raw occurrence count</li>
                            <li><strong>Weighted Density:</strong> Position-based weighting</li>
                            <li><strong>Prominence Score:</strong> Location importance</li>
                            <li><strong>Competitive Density:</strong> Comparison with top results</li>
                        </ul>

                        <h3>Advanced Keyword Analysis Techniques</h3>

                        <h4>Keyword Proximity</h4>

                        <p>Analyzing how close keywords appear to each other:</p>

                        <ul>
                            <li><strong>Exact Match:</strong> Keywords appearing together</li>
                            <li><strong>Phrase Match:</strong> Keywords in same sentence</li>
                            <li><strong>Paragraph Match:</strong> Keywords in same section</li>
                            <li><strong>Document Match:</strong> Keywords anywhere in content</li>
                        </ul>

                        <h4>Keyword Distribution</h4>

                        <p>Analyzing keyword placement throughout content:</p>

                        <ul>
                            <li><strong>Title Density:</strong> Keywords in headings</li>
                            <li><strong>Introduction Density:</strong> Keywords in opening</li>
                            <li><strong>Body Density:</strong> Keywords in main content</li>
                            <li><strong>Conclusion Density:</strong> Keywords in closing</li>
                        </ul>

                        <h3>Common Keyword Density Mistakes</h3>

                        <h4>Over-Optimization</h4>

                        <p>Avoiding keyword stuffing and over-optimization:</p>

                        <ul>
                            <li><strong>Keyword Stuffing:</strong> Excessive keyword repetition</li>
                            <li><strong>Unnatural Density:</strong> Artificially high percentages</li>
                            <li><strong>Irrelevant Keywords:</strong> Force-fitting unrelated terms</li>
                            <li><strong>Poor Readability:</strong> Sacrificing user experience</li>
                        </ul>

                        <h4>Under-Optimization</h4>

                        <p>Avoiding missed optimization opportunities:</p>

                        <ul>
                            <li><strong>Missing Keywords:</strong> Important terms not included</li>
                            <li><strong>Low Density:</strong> Insufficient keyword presence</li>
                            <li><strong>Wrong Variations:</strong> Using incorrect keyword forms</li>
                            <li><strong>Competitive Gap:</strong> Lower density than competitors</li>
                        </ul>

                        <h3>Keyword Density Tools and Software</h3>

                        <p>Tools for analyzing keyword density:</p>

                        <ul>
                            <li><strong>Online Analyzers:</strong> Web-based density checkers</li>
                            <li><strong>SEO Plugins:</strong> WordPress SEO extensions</li>
                            <li><strong>Writing Tools:</strong> Content optimization software</li>
                            <li><strong>API Services:</strong> Programmatic analysis</li>
                        </ul>

                        <h3>Content Optimization Strategies</h3>

                        <h4>Natural Keyword Integration</h4>

                        <p>Strategies for natural keyword placement:</p>

                        <ul>
                            <li><strong>Topic Clusters:</strong> Group related keywords</li>
                            <li><strong>LSI Keywords:</strong> Include semantically related terms</li>
                            <li><strong>Long-tail Phrases:</strong> Use specific search queries</li>
                            <li><strong>User Intent:</strong> Match search query intent</li>
                        </ul>

                        <h4>Content Structure Optimization</h4>

                        <p>Optimizing content structure for keywords:</p>

                        <ul>
                            <li><strong>Heading Hierarchy:</strong> Keywords in H1, H2, H3 tags</li>
                            <li><strong>Introduction:</strong> Primary keywords early</li>
                            <li><strong>Body Content:</strong> Natural keyword distribution</li>
                            <li><strong>Meta Elements:</strong> Keywords in title and description</li>
                        </ul>

                        <h3>Measuring Keyword Density Success</h3>

                        <h4>SEO Performance Metrics</h4>

                        <p>Evaluating keyword density impact:</p>

                        <ul>
                            <li><strong>Ranking Improvement:</strong> Search position changes</li>
                            <li><strong>Traffic Increase:</strong> Organic search visitors</li>
                            <li><strong>Conversion Rates:</strong> Goal completion improvements</li>
                            <li><strong>Dwell Time:</strong> User engagement metrics</li>
                        </ul>

                        <h4>Content Quality Metrics</h4>

                        <p>Assessing content optimization quality:</p>

                        <ul>
                            <li><strong>Readability Scores:</strong> Flesch reading ease</li>
                            <li><strong>User Engagement:</strong> Time on page, bounce rate</li>
                            <li><strong>Social Shares:</strong> Content sharing metrics</li>
                            <li><strong>Backlink Growth:</strong> External link acquisition</li>
                        </ul>

                        <h3>Industry-Specific Density Guidelines</h3>

                        <h4>E-commerce Content</h4>

                        <p>Density recommendations for product pages:</p>

                        <ul>
                            <li><strong>Product Names:</strong> 2.0% - 4.0%</li>
                            <li><strong>Category Terms:</strong> 1.5% - 3.0%</li>
                            <li><strong>Brand Terms:</strong> 1.0% - 2.5%</li>
                            <li><strong>Feature Keywords:</strong> 0.8% - 2.0%</li>
                        </ul>

                        <h4>Blog Content</h4>

                        <p>Density guidelines for blog posts:</p>

                        <ul>
                            <li><strong>Primary Topic:</strong> 1.5% - 2.5%</li>
                            <li><strong>Related Terms:</strong> 1.0% - 2.0%</li>
                            <li><strong>Question Keywords:</strong> 0.5% - 1.5%</li>
                            <li><strong>LSI Keywords:</strong> 0.3% - 1.0%</li>
                        </ul>

                        <h3>Future of Keyword Density</h3>

                        <p>Evolving trends in keyword optimization:</p>

                        <ul>
                            <li><strong>Semantic SEO:</strong> Topic and entity-based optimization</li>
                            <li><strong>AI-Powered Analysis:</strong> Machine learning optimization</li>
                            <li><strong>Voice Search:</strong> Conversational keyword targeting</li>
                            <li><strong>Visual Search:</strong> Image and video keyword optimization</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Keyword density analysis is a crucial component of effective SEO strategy, helping content creators optimize their writing for both search engines and human readers. Understanding optimal density ranges, avoiding common pitfalls, and implementing natural optimization techniques will improve search visibility and user engagement.</p>

                        <p>Regular keyword density analysis, combined with quality content creation and user-focused optimization, creates a comprehensive approach to content marketing success. Remember that while keyword density is important, content quality and user experience should always take precedence over mechanical optimization.</p>

                        <p>Combine keyword density checking with our <a href="<?php echo $base_url; ?>/tools/meta-tag-analyzer">meta tag analyzer tool</a> and <a href="<?php echo $base_url; ?>/tools/article-rewriter">article rewriter tool</a> for complete content optimization.</p>

                        <p>For more information about keyword density and SEO, check the <a href="https://developers.google.com/search/docs/advanced/guidelines/webmaster-guidelines" target="_blank" rel="noopener">Google Webmaster Guidelines</a> and <a href="https://moz.com/learn/seo/keyword-density" target="_blank" rel="noopener">Moz's SEO guide</a>. Start analyzing your keyword density today and optimize your content for better search performance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🏷️</div>
                        <h4>Meta Tag Analyzer</h4>
                        <p>Analyze and optimize meta tags for better SEO performance.</p>
                        <a href="<?php echo $base_url; ?>/tools/meta-tag-analyzer" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">✏️</div>
                        <h4>Article Rewriter</h4>
                        <p>Rewrite and optimize articles for better SEO and readability.</p>
                        <a href="<?php echo $base_url; ?>/tools/article-rewriter" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📝</div>
                        <h4>Grammar Checker</h4>
                        <p>Check grammar, spelling, and writing quality in your content.</p>
                        <a href="<?php echo $base_url; ?>/tools/grammar-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('densityCheckerForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const content = document.getElementById('contentText').value.trim();
            const primaryKeyword = document.getElementById('primaryKeyword').value.trim();
            const analyzeSingleWords = document.getElementById('analyzeSingleWords').checked;
            const analyzePhrases = document.getElementById('analyzePhrases').checked;
            const includeStopWords = document.getElementById('includeStopWords').checked;
            const caseSensitive = document.getElementById('caseSensitive').checked;
            const resultsDiv = document.getElementById('densityResults');

            if (!content) {
                alert('Please enter some content to analyze.');
                return;
            }

            if (content.split(/\s+/).length < 50) {
                alert('Please enter at least 50 words for meaningful analysis.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing keyword density...</p></div>';

            // In a real implementation, this would perform actual keyword density analysis
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const wordCount = content.split(/\s+/).length;
                const charCount = content.length;
                const sentenceCount = content.split(/[.!?]+/).length - 1;
                const paragraphCount = content.split(/\n\s*\n/).length;

                // Mock keyword analysis
                const mockKeywords = [
                    { word: 'content', count: 8, density: ((8/wordCount)*100).toFixed(2) },
                    { word: 'keyword', count: 6, density: ((6/wordCount)*100).toFixed(2) },
                    { word: 'seo', count: 5, density: ((5/wordCount)*100).toFixed(2) },
                    { word: 'optimization', count: 4, density: ((4/wordCount)*100).toFixed(2) },
                    { word: 'analysis', count: 4, density: ((4/wordCount)*100).toFixed(2) },
                    { word: 'search', count: 3, density: ((3/wordCount)*100).toFixed(2) },
                    { word: 'density', count: 3, density: ((3/wordCount)*100).toFixed(2) },
                    { word: 'website', count: 2, density: ((2/wordCount)*100).toFixed(2) }
                ];

                const primaryDensity = primaryKeyword ? ((content.toLowerCase().split(primaryKeyword.toLowerCase()).length - 1) / wordCount * 100).toFixed(2) : 0;

                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Keyword Density Analysis Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Content Summary</h5>
                            <div class="alert alert-info">
                                <strong>Total Words:</strong> ${wordCount}<br>
                                <strong>Total Characters:</strong> ${charCount}<br>
                                <strong>Sentences:</strong> ${sentenceCount}<br>
                                <strong>Paragraphs:</strong> ${paragraphCount}<br>
                                <strong>Reading Time:</strong> ${Math.round(wordCount / 200)} minutes
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Density Overview</h5>
                            <div class="alert alert-success">
                                <strong>Unique Keywords:</strong> ${mockKeywords.length}<br>
                                <strong>Primary Keyword:</strong> ${primaryKeyword || 'Not specified'}<br>
                                <strong>Primary Density:</strong> ${primaryDensity}%<br>
                                <strong>Optimization Score:</strong> ${calculateOptimizationScore(primaryDensity, wordCount)}/100
                            </div>
                        </div>
                    </div>
                    ${primaryKeyword ? `
                    <div class="mt-4">
                        <h5>Primary Keyword Analysis</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <h6>"${primaryKeyword}"</h6>
                                        <div class="progress mb-2" style="height: 20px;">
                                            <div class="progress-bar ${getDensityClass(primaryDensity)}" role="progressbar" style="width: ${Math.min(primaryDensity * 10, 100)}%" aria-valuenow="${primaryDensity}" aria-valuemin="0" aria-valuemax="100">
                                                ${primaryDensity}%
                                            </div>
                                        </div>
                                        <small class="text-muted">Recommended range: 1.0% - 2.5% for optimal SEO</small>
                                    </div>
                                    <div class="col-md-4 text-center">
                                        <div class="border rounded p-3">
                                            <h4 class="${primaryDensity >= 1.0 && primaryDensity <= 2.5 ? 'text-success' : primaryDensity > 2.5 ? 'text-warning' : 'text-danger'}">
                                                ${primaryDensity}%
                                            </h4>
                                            <small>Density</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    <div class="mt-4">
                        <h5>Top Keywords by Density</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Keyword</th>
                                        <th>Frequency</th>
                                        <th>Density</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${mockKeywords.map(keyword => `
                                        <tr>
                                            <td><strong>${keyword.word}</strong></td>
                                            <td>${keyword.count}</td>
                                            <td>${keyword.density}%</td>
                                            <td>
                                                <span class="badge ${getDensityStatus(keyword.density)}">
                                                    ${keyword.density >= 0.5 && keyword.density <= 2.0 ? 'Good' : keyword.density > 2.0 ? 'High' : 'Low'}
                                                </span>
                                            </td>
                                        </tr>
                                    `).join('')}
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Keyword Distribution Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Density Ranges</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Low Density (0-0.5%)</strong>
                                            <br><small>Keywords that may need more focus</small>
                                        </div>
                                        <span class="badge bg-secondary">${mockKeywords.filter(k => k.density < 0.5).length}</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Optimal Density (0.5-2.0%)</strong>
                                            <br><small>Well-optimized keywords</small>
                                        </div>
                                        <span class="badge bg-success">${mockKeywords.filter(k => k.density >= 0.5 && k.density <= 2.0).length}</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>High Density (2.0%+)</strong>
                                            <br><small>Keywords that may be over-optimized</small>
                                        </div>
                                        <span class="badge bg-warning">${mockKeywords.filter(k => k.density > 2.0).length}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Content Quality Metrics</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Keyword Diversity</strong>
                                            <br><small>Unique keywords used</small>
                                        </div>
                                        <span class="badge bg-info">${mockKeywords.length}</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Readability Score</strong>
                                            <br><small>Flesch Reading Ease</small>
                                        </div>
                                        <span class="badge bg-primary">68</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>Content Length</strong>
                                            <br><small>Word count assessment</small>
                                        </div>
                                        <span class="badge ${wordCount >= 300 ? 'bg-success' : 'bg-warning'}">${wordCount >= 300 ? 'Good' : 'Short'}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Optimization Recommendations</h5>
                        <div class="alert alert-info">
                            <h6>✅ Strengths</h6>
                            <ul class="mb-3">
                                <li>Good keyword diversity with ${mockKeywords.length} unique terms</li>
                                <li>Content length is ${wordCount >= 300 ? 'adequate' : 'sufficient'} for SEO</li>
                                <li>Natural keyword distribution throughout the content</li>
                            </ul>

                            <h6>💡 Suggestions for Improvement</h6>
                            <ul class="mb-3">
                                ${primaryKeyword && primaryDensity < 1.0 ? `<li>Consider increasing the density of your primary keyword "${primaryKeyword}" (currently ${primaryDensity}%, recommended 1.0-2.0%)</li>` : ''}
                                ${mockKeywords.filter(k => k.density > 2.5).length > 0 ? '<li>Some keywords have high density - consider reducing repetition for better readability</li>' : ''}
                                <li>Include more long-tail keyword phrases for better search visibility</li>
                                <li>Add LSI (Latent Semantic Indexing) keywords related to your topic</li>
                            </ul>

                            <h6>🎯 Next Steps</h6>
                            <ul class="mb-0">
                                <li>Review content for natural keyword integration</li>
                                <li>Test different keyword variations</li>
                                <li>Monitor search performance after optimization</li>
                                <li>Consider user intent and search query analysis</li>
                            </ul>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="exportDensityReport()">
                                📄 Export Report
                            </button>
                            <button class="btn btn-outline-primary" onclick="suggestKeywords()">
                                💡 Get Keyword Suggestions
                            </button>
                            <button class="btn btn-outline-primary" onclick="optimizeContent()">
                                ⚡ Optimize Content
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                🗑️ Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function calculateOptimizationScore(primaryDensity, wordCount) {
            let score = 50; // Base score

            // Primary keyword density (40 points)
            if (primaryDensity >= 1.0 && primaryDensity <= 2.5) {
                score += 40;
            } else if (primaryDensity >= 0.5 && primaryDensity <= 3.0) {
                score += 25;
            } else if (primaryDensity > 0) {
                score += 10;
            }

            // Content length (30 points)
            if (wordCount >= 1000) {
                score += 30;
            } else if (wordCount >= 500) {
                score += 20;
            } else if (wordCount >= 300) {
                score += 10;
            }

            // Keyword diversity (20 points) - assuming good diversity
            score += 15;

            return Math.min(score, 100);
        }

        function getDensityClass(density) {
            if (density >= 1.0 && density <= 2.5) return 'bg-success';
            if (density > 2.5) return 'bg-warning';
            return 'bg-danger';
        }

        function getDensityStatus(density) {
            if (density >= 0.5 && density <= 2.0) return 'bg-success';
            if (density > 2.0) return 'bg-warning';
            return 'bg-secondary';
        }

        function exportDensityReport() {
            const content = document.getElementById('contentText').value;
            const wordCount = content.split(/\s+/).length;
            const primaryKeyword = document.getElementById('primaryKeyword').value;
            const primaryDensity = primaryKeyword ? ((content.toLowerCase().split(primaryKeyword.toLowerCase()).length - 1) / wordCount * 100).toFixed(2) : 0;

            const reportData = `Keyword Density Analysis Report
Generated: ${new Date().toLocaleString()}

CONTENT SUMMARY:
- Total Words: ${wordCount}
- Total Characters: ${content.length}
- Primary Keyword: ${primaryKeyword || 'Not specified'}
- Primary Density: ${primaryDensity}%

TOP KEYWORDS:
- content: 8 (1.60%)
- keyword: 6 (1.20%)
- seo: 5 (1.00%)
- optimization: 4 (0.80%)
- analysis: 4 (0.80%)

OPTIMIZATION SCORE: ${calculateOptimizationScore(primaryDensity, wordCount)}/100

RECOMMENDATIONS:
1. ${primaryDensity < 1.0 ? 'Increase primary keyword density' : 'Primary keyword density is good'}
2. Ensure natural keyword distribution
3. Add more long-tail keywords
4. Maintain readability while optimizing

Generated by Loganix SEO Tools`;

            const blob = new Blob([reportData], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'keyword-density-report.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function suggestKeywords() {
            const content = document.getElementById('contentText').value.toLowerCase();
            const suggestions = [];

            // Mock keyword suggestions based on content
            if (content.includes('seo') || content.includes('search')) {
                suggestions.push('search engine optimization', 'seo strategy', 'keyword research');
            }
            if (content.includes('content') || content.includes('article')) {
                suggestions.push('content marketing', 'article writing', 'blog posts');
            }
            if (content.includes('keyword') || content.includes('density')) {
                suggestions.push('keyword density checker', 'seo tools', 'content optimization');
            }

            alert(`Keyword Suggestions for Your Content:

${suggestions.map((kw, i) => `${i + 1}. ${kw}`).join('\n')}

These suggestions are based on your content topic and can help improve SEO performance.`);
        }

        function optimizeContent() {
            alert(`Content Optimization Assistant:

1. PRIMARY KEYWORD: Ensure your main keyword appears naturally in:
   - Title (first few words)
   - First paragraph
   - At least one heading
   - Throughout the content (1-2% density)

2. SECONDARY KEYWORDS: Include related terms like:
   - Synonyms of your primary keyword
   - Long-tail keyword variations
   - LSI (Latent Semantic Indexing) keywords

3. CONTENT STRUCTURE:
   - Use keywords in H1, H2, H3 headings
   - Include keywords in image alt text
   - Add keywords to meta description
   - Use keywords in internal links

4. READABILITY: Maintain natural flow while optimizing for search engines.

Would you like me to help optimize your content?`);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('contentText').value = '';
            document.getElementById('primaryKeyword').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>