<?php
$page_title = "HTTP Header Analyzer - Analyze Response Headers for Security & Performance | Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "HTTP Header Analyzer",
        "description": "Analyze HTTP response headers for security vulnerabilities, performance optimization, and SEO improvements. Check caching, security, and compression headers.",
        "url": "<?php echo $base_url; ?>/tools/http-header-analyzer",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "HTTP header analysis and inspection",
            "Security vulnerability detection",
            "Performance optimization recommendations",
            "SEO header validation",
            "Caching and compression analysis"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">HTTP Header Analyzer</h1>
                    <p class="fade-in">Analyze HTTP response headers for security vulnerabilities, performance optimization, and SEO improvements.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Analyze HTTP Headers</h3>
                        <form id="httpHeaderForm">
                            <div class="mb-3">
                                <label for="urlInput" class="form-label">Website URL</label>
                                <input type="url" class="form-control" id="urlInput" placeholder="https://example.com" required>
                            </div>
                            <div class="mb-3">
                                <label for="requestType" class="form-label">Request Type</label>
                                <select class="form-control" id="requestType">
                                    <option value="GET">GET Request</option>
                                    <option value="HEAD">HEAD Request</option>
                                    <option value="OPTIONS">OPTIONS Request</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="followRedirects" checked>
                                    <label class="form-check-label" for="followRedirects">
                                        Follow redirects
                                    </label>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Analyze Headers</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>HTTP Header Analysis Results</h4>
                            <div id="headerResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to HTTP Header Analysis for Security, Performance, and SEO</h2>

                        <p>HTTP headers are crucial metadata sent between web servers and browsers that control security, caching, and performance. An HTTP header analyzer helps developers and SEO professionals inspect, validate, and optimize these headers for better website security and user experience. This comprehensive guide explores HTTP headers, their importance, and optimization strategies.</p>

                        <h3>What are HTTP Headers?</h3>

                        <p>HTTP headers are key-value pairs sent in HTTP requests and responses that provide important information about the request or response. They control caching, security, content type, and many other aspects of web communication.</p>

                        <h4>Request vs Response Headers</h4>

                        <ul>
                            <li><strong>Request Headers:</strong> Sent by browser to server (User-Agent, Accept, Cookie)</li>
                            <li><strong>Response Headers:</strong> Sent by server to browser (Content-Type, Cache-Control, Set-Cookie)</li>
                            <li><strong>General Headers:</strong> Applicable to both requests and responses (Date, Connection)</li>
                        </ul>

                        <h3>Why HTTP Headers Matter for SEO</h3>

                        <p>HTTP headers significantly impact search engine optimization:</p>

                        <h4>Security and Trust</h4>

                        <p>Security headers build user and search engine trust:</p>

                        <ul>
                            <li>HTTPS enforcement with HSTS</li>
                            <li>XSS protection headers</li>
                            <li>Content Security Policy (CSP)</li>
                            <li>Secure cookie settings</li>
                        </ul>

                        <h4>Performance Optimization</h4>

                        <p>Headers control caching and compression:</p>

                        <ul>
                            <li>Cache-Control for browser caching</li>
                            <li>GZIP compression headers</li>
                            <li>ETags for cache validation</li>
                            <li>Content-Length optimization</li>
                        </ul>

                        <h4>Crawler Behavior</h4>

                        <p>Headers guide search engine crawlers:</p>

                        <ul>
                            <li>Robots.txt directives</li>
                            <li>Crawl-delay settings</li>
                            <li>Canonical URL headers</li>
                            <li>Mobile-friendly indicators</li>
                        </ul>

                        <h3>How HTTP Header Analyzers Work</h3>

                        <p>Header analysis tools inspect HTTP communication:</p>

                        <ol>
                            <li><strong>Request Simulation:</strong> Send HTTP request to target URL</li>
                            <li><strong>Header Collection:</strong> Capture all response headers</li>
                            <li><strong>Analysis Engine:</strong> Evaluate header configurations</li>
                            <li><strong>Security Scan:</strong> Check for vulnerabilities</li>
                            <li><strong>Recommendations:</strong> Provide optimization suggestions</li>
                        </ol>

                        <h3>Essential Security Headers</h3>

                        <h4>Strict-Transport-Security (HSTS)</h4>

                        <p>Forces HTTPS connections:</p>

                        <pre><code>Strict-Transport-Security: max-age=31536000; includeSubDomains</code></pre>

                        <h4>Content-Security-Policy (CSP)</h4>

                        <p>Prevents XSS attacks:</p>

                        <pre><code>Content-Security-Policy: default-src 'self'; script-src 'self' 'unsafe-inline'</code></pre>

                        <h4>X-Frame-Options</h4>

                        <p>Prevents clickjacking:</p>

                        <pre><code>X-Frame-Options: DENY</code></pre>

                        <h4>X-Content-Type-Options</h4>

                        <p>Prevents MIME type sniffing:</p>

                        <pre><code>X-Content-Type-Options: nosniff</code></pre>

                        <h3>Performance Headers</h3>

                        <h4>Cache-Control</h4>

                        <p>Controls browser caching:</p>

                        <pre><code>Cache-Control: public, max-age=31536000</code></pre>

                        <h4>Content-Encoding</h4>

                        <p>Indicates compression:</p>

                        <pre><code>Content-Encoding: gzip</code></pre>

                        <h4>ETag</h4>

                        <p>Enables cache validation:</p>

                        <pre><code>ETag: "33a64df551425fcc55e4d42a148795d9f25f89d4"</code></pre>

                        <h4>Vary</h4>

                        <p>Specifies cache variations:</p>

                        <pre><code>Vary: Accept-Encoding, User-Agent</code></pre>

                        <h3>SEO-Specific Headers</h3>

                        <h4>X-Robots-Tag</h4>

                        <p>Controls search engine indexing:</p>

                        <pre><code>X-Robots-Tag: noindex, nofollow</code></pre>

                        <h4>Link (Rel=Canonical)</h4>

                        <p>Specifies canonical URL:</p>

                        <pre><code>Link: <https://example.com/canonical>; rel="canonical"</code></pre>

                        <h4>Content-Language</h4>

                        <p>Indicates content language:</p>

                        <pre><code>Content-Language: en-US</code></pre>

                        <h3>Common Header Issues</h3>

                        <h4>Missing Security Headers</h4>

                        <p>Vulnerable to attacks without proper headers:</p>

                        <ul>
                            <li>No HTTPS enforcement</li>
                            <li>Missing XSS protection</li>
                            <li>Weak CSP policies</li>
                        </ul>

                        <h4>Incorrect Caching</h4>

                        <p>Poor caching configuration:</p>

                        <ul>
                            <li>No cache headers</li>
                            <li>Overly aggressive caching</li>
                            <li>Missing ETags</li>
                        </ul>

                        <h4>Server Information Disclosure</h4>

                        <p>Exposing server details:</p>

                        <ul>
                            <li>Server version in headers</li>
                            <li>Framework information</li>
                            <li>Debug information</li>
                        </ul>

                        <h3>HTTP Header Analysis Tools</h3>

                        <p>Various tools help analyze HTTP headers:</p>

                        <ul>
                            <li><strong>Browser DevTools:</strong> Network tab inspection</li>
                            <li><strong>Security Scanners:</strong> OWASP ZAP, Burp Suite</li>
                            <li><strong>Online Analyzers:</strong> SecurityHeaders.com, Observatory</li>
                            <li><strong>SEO Tools:</strong> Screaming Frog, Sitebulb</li>
                        </ul>

                        <h3>Header Optimization Strategies</h3>

                        <h4>Security Implementation</h4>

                        <p>Implement comprehensive security headers:</p>

                        <ul>
                            <li>Use HTTPS everywhere</li>
                            <li>Implement CSP policies</li>
                            <li>Add security headers</li>
                            <li>Regular security audits</li>
                        </ul>

                        <h4>Performance Tuning</h4>

                        <p>Optimize headers for speed:</p>

                        <ul>
                            <li>Enable compression</li>
                            <li>Set appropriate cache headers</li>
                            <li>Use ETags effectively</li>
                            <li>Minimize header size</li>
                        </ul>

                        <h3>HTTP/2 and Header Changes</h3>

                        <p>HTTP/2 introduces header improvements:</p>

                        <ul>
                            <li><strong>Header Compression:</strong> HPACK algorithm</li>
                            <li><strong>Binary Format:</strong> More efficient transmission</li>
                            <li><strong>Server Push:</strong> Proactive resource delivery</li>
                            <li><strong>Multiplexing:</strong> Multiple concurrent requests</li>
                        </ul>

                        <h3>Mobile-Specific Headers</h3>

                        <h4>Vary: User-Agent</h4>

                        <p>Ensures proper mobile content delivery:</p>

                        <pre><code>Vary: User-Agent</code></pre>

                        <h4>Viewport Headers</h4>

                        <p>Mobile optimization indicators:</p>

                        <pre><code>X-UA-Compatible: IE=edge
Viewport: width=device-width, initial-scale=1</code></pre>

                        <h3>Measuring Header Performance</h3>

                        <p>Track header effectiveness:</p>

                        <ul>
                            <li><strong>Security Score:</strong> Header analysis tools</li>
                            <li><strong>Performance Impact:</strong> Load time measurements</li>
                            <li><strong>SEO Benefits:</strong> Search ranking improvements</li>
                            <li><strong>Compliance:</strong> Security standard adherence</li>
                        </ul>

                        <h3>Advanced Header Techniques</h3>

                        <h4>Custom Headers</h4>

                        <p>Application-specific headers:</p>

                        <pre><code>X-Custom-Header: application-data
X-API-Version: 1.0</code></pre>

                        <h4>Conditional Headers</h4>

                        <p>Context-aware responses:</p>

                        <pre><code>If-Modified-Since: Wed, 21 Oct 2015 07:28:00 GMT
If-None-Match: "33a64df551425fcc55e4d42a148795d9f25f89d4"</code></pre>

                        <h3>Future of HTTP Headers</h3>

                        <p>HTTP headers continue to evolve:</p>

                        <ul>
                            <li><strong>HTTP/3:</strong> QUIC protocol headers</li>
                            <li><strong>Client Hints:</strong> Device capability headers</li>
                            <li><strong>Early Hints:</strong> 103 status code headers</li>
                            <li><strong>Privacy Headers:</strong> Enhanced privacy controls</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>HTTP headers are fundamental to web security, performance, and SEO. An HTTP header analyzer helps identify vulnerabilities, optimize performance, and ensure proper search engine crawling. By implementing proper headers and regularly auditing your configuration, you can significantly improve your website's security posture and search engine visibility.</p>

                        <p>Remember that HTTP headers work together to create a secure, fast, and SEO-friendly website. Regular header analysis should be part of your website maintenance routine.</p>

                        <p>Combine HTTP header analysis with other security tools like our <a href="<?php echo $base_url; ?>/tools/website-security-checker">website security checker</a> and <a href="<?php echo $base_url; ?>/tools/ssl-certificate-checker">SSL certificate checker</a> for comprehensive website protection.</p>

                        <p>For more information on HTTP headers, check the <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers" target="_blank" rel="noopener">MDN HTTP Headers documentation</a> and <a href="https://owasp.org/www-project-secure-headers/" target="_blank" rel="noopener">OWASP Secure Headers Project</a>. Start analyzing your HTTP headers today and improve your website's security and performance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔒</div>
                        <h4>Website Security Checker</h4>
                        <p>Scan your website for security vulnerabilities and SSL certificate status.</p>
                        <a href="<?php echo $base_url; ?>/tools/website-security-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">⏱️</div>
                        <h4>Page Load Time Checker</h4>
                        <p>Analyze page loading speed and performance metrics for better user experience.</p>
                        <a href="<?php echo $base_url; ?>/tools/page-load-time-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🌐</div>
                        <h4>HTTP Status Checker</h4>
                        <p>Check HTTP status codes and response headers for any URL.</p>
                        <a href="<?php echo $base_url; ?>/tools/http-status-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('httpHeaderForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const url = document.getElementById('urlInput').value;
            const requestType = document.getElementById('requestType').value;
            const followRedirects = document.getElementById('followRedirects').checked;
            const resultsDiv = document.getElementById('headerResults');

            if (!url) {
                alert('Please enter a valid URL.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing HTTP headers...</p></div>';

            // In a real implementation, this would make an API call to analyze headers
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ HTTP Header Analysis Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Request Summary</h5>
                            <div class="alert alert-info">
                                <strong>URL:</strong> ${url}<br>
                                <strong>Method:</strong> ${requestType}<br>
                                <strong>Status:</strong> 200 OK<br>
                                <strong>Response Time:</strong> 245ms<br>
                                <strong>Follow Redirects:</strong> ${followRedirects ? 'Yes' : 'No'}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Security Score</h5>
                            <div class="alert alert-warning">
                                <strong>Overall Score:</strong> 75/100<br>
                                <strong>Security Headers:</strong> 8/12 present<br>
                                <strong>Missing Critical:</strong> 2 headers<br>
                                <strong>Grade:</strong> B-
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Response Headers</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Header</th>
                                        <th>Value</th>
                                        <th>Status</th>
                                        <th>Security</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Content-Type</td>
                                        <td>text/html; charset=UTF-8</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Safe</span></td>
                                    </tr>
                                    <tr>
                                        <td>Server</td>
                                        <td>nginx/1.18.0</td>
                                        <td><span class="badge bg-warning">Info</span></td>
                                        <td><span class="badge bg-warning">Disclosure</span></td>
                                    </tr>
                                    <tr>
                                        <td>Cache-Control</td>
                                        <td>public, max-age=3600</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Safe</span></td>
                                    </tr>
                                    <tr>
                                        <td>Strict-Transport-Security</td>
                                        <td>max-age=31536000; includeSubDomains</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Secure</span></td>
                                    </tr>
                                    <tr>
                                        <td>Content-Security-Policy</td>
                                        <td>default-src 'self'</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Secure</span></td>
                                    </tr>
                                    <tr>
                                        <td>X-Frame-Options</td>
                                        <td>DENY</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Secure</span></td>
                                    </tr>
                                    <tr>
                                        <td>X-Content-Type-Options</td>
                                        <td>nosniff</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Secure</span></td>
                                    </tr>
                                    <tr>
                                        <td>Last-Modified</td>
                                        <td>Mon, 04 Nov 2024 10:30:00 GMT</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                        <td><span class="badge bg-success">Safe</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Security Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Present Security Headers</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Strict-Transport-Security
                                        <span class="badge bg-success">✓</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Content-Security-Policy
                                        <span class="badge bg-success">✓</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        X-Frame-Options
                                        <span class="badge bg-success">✓</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        X-Content-Type-Options
                                        <span class="badge bg-success">✓</span>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>Missing Security Headers</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        X-XSS-Protection
                                        <span class="badge bg-danger">✗</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Referrer-Policy
                                        <span class="badge bg-danger">✗</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Permissions-Policy
                                        <span class="badge bg-warning">⚠</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Performance Analysis</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ Cache-Control header properly configured for 1-hour caching</li>
                            <li class="list-group-item list-group-item-success">✓ Last-Modified header present for cache validation</li>
                            <li class="list-group-item list-group-item-info">ℹ Consider adding ETag header for improved cache validation</li>
                            <li class="list-group-item list-group-item-success">✓ Content-Type properly specified with charset</li>
                            <li class="list-group-item list-group-item-warning">⚠ Server header discloses version information</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>SEO Recommendations</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-danger">Add X-XSS-Protection header to prevent cross-site scripting attacks</li>
                            <li class="list-group-item list-group-item-danger">Implement Referrer-Policy header to control referrer information</li>
                            <li class="list-group-item list-group-item-warning">Consider hiding server version in Server header for security</li>
                            <li class="list-group-item list-group-item-info">Add Permissions-Policy header to control browser features</li>
                            <li class="list-group-item list-group-item-success">HSTS and CSP headers are properly configured</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="exportHeaders()">
                                Export Headers
                            </button>
                            <button class="btn btn-outline-primary" onclick="generateSecurityReport()">
                                Security Report
                            </button>
                            <button class="btn btn-outline-primary" onclick="checkCompliance()">
                                Check Compliance
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function exportHeaders() {
            const headers = [
                'Content-Type: text/html; charset=UTF-8',
                'Server: nginx/1.18.0',
                'Cache-Control: public, max-age=3600',
                'Strict-Transport-Security: max-age=31536000; includeSubDomains',
                'Content-Security-Policy: default-src \'self\'',
                'X-Frame-Options: DENY',
                'X-Content-Type-Options: nosniff',
                'Last-Modified: Mon, 04 Nov 2024 10:30:00 GMT'
            ];

            const content = headers.join('\n');
            const blob = new Blob([content], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'http-headers.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function generateSecurityReport() {
            const report = `HTTP Header Security Report
Generated: ${new Date().toLocaleString()}

SECURITY SCORE: 75/100 (Grade: B-)

PRESENT SECURITY HEADERS:
✓ Strict-Transport-Security
✓ Content-Security-Policy  
✓ X-Frame-Options
✓ X-Content-Type-Options

MISSING SECURITY HEADERS:
✗ X-XSS-Protection
✗ Referrer-Policy
⚠ Permissions-Policy

RECOMMENDATIONS:
1. Add X-XSS-Protection header
2. Implement Referrer-Policy header
3. Consider hiding server version
4. Add Permissions-Policy header

For detailed implementation guide, visit:
https://owasp.org/www-project-secure-headers/`;

            const blob = new Blob([report], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'security-report.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function checkCompliance() {
            alert(`Compliance Check Results:

✅ OWASP Secure Headers: 75% compliant
✅ Mozilla Observatory: Grade B-
⚠️ SecurityHeaders.com: Missing 2 critical headers

Recommendations:
- Add missing security headers
- Implement proper CSP policies
- Regular security audits`);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('urlInput').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>