<?php
$page_title = "Favicon Generator - Create Website Favicons Online | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Favicon Generator",
        "description": "Free online favicon generator tool to create website favicons from images, text, or emojis. Generate multiple sizes and formats for perfect browser compatibility.",
        "url": "<?php echo $base_url; ?>/tools/favicon-generator",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Generate favicons from images, text, and emojis",
            "Multiple size formats (16x16, 32x32, 48x48, 64x64)",
            "PNG, ICO, and Apple Touch Icon support",
            "Real-time preview and customization",
            "HTML code generation for easy implementation",
            "Cross-browser compatibility"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Favicon Generator</h1>
                    <p class="fade-in">Create professional favicons from images, text, or emojis for your website instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Create Your Favicon</h3>
                        <form id="faviconGeneratorForm">
                            <div class="mb-3">
                                <label class="form-label">Favicon Source</label>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="sourceType" id="sourceImage" value="image" checked>
                                            <label class="form-check-label" for="sourceImage">
                                                Upload Image
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="sourceType" id="sourceText" value="text">
                                            <label class="form-check-label" for="sourceText">
                                                Text/Emoji
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="sourceType" id="sourceUrl" value="url">
                                            <label class="form-check-label" for="sourceUrl">
                                                Image URL
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Image Upload Section -->
                            <div id="imageUploadSection" class="mb-3">
                                <label for="imageFile" class="form-label">Upload Image</label>
                                <input type="file" class="form-control" id="imageFile" accept="image/*">
                                <div class="form-text">Supported formats: PNG, JPG, JPEG, GIF, SVG (max 5MB)</div>
                            </div>

                            <!-- Text Input Section -->
                            <div id="textInputSection" class="mb-3" style="display: none;">
                                <label for="faviconText" class="form-label">Text or Emoji</label>
                                <input type="text" class="form-control" id="faviconText" placeholder="A" maxlength="2">
                                <div class="form-text">Enter 1-2 characters or emojis</div>
                            </div>

                            <!-- URL Input Section -->
                            <div id="urlInputSection" class="mb-3" style="display: none;">
                                <label for="imageUrl" class="form-label">Image URL</label>
                                <input type="url" class="form-control" id="imageUrl" placeholder="https://example.com/image.png">
                                <div class="form-text">Enter direct link to image file</div>
                            </div>

                            <!-- Customization Options -->
                            <div class="mb-3">
                                <label class="form-label">Customization</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="bgColor" class="form-label">Background Color</label>
                                        <input type="color" class="form-control form-control-color" id="bgColor" value="#0153C8">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="textColor" class="form-label">Text/Icon Color</label>
                                        <input type="color" class="form-control form-control-color" id="textColor" value="#ffffff">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Output Formats</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="formatIco" checked>
                                            <label class="form-check-label" for="formatIco">
                                                ICO format (Windows)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="formatPng" checked>
                                            <label class="form-check-label" for="formatPng">
                                                PNG format (Modern browsers)
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="formatApple" checked>
                                            <label class="form-check-label" for="formatApple">
                                                Apple Touch Icon
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="formatSvg">
                                            <label class="form-check-label" for="formatSvg">
                                                SVG format (Scalable)
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Generate Favicon</button>
                        </form>
                    </div>

                    <!-- Preview Section -->
                    <div id="previewSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Favicon Preview</h4>
                            <div id="faviconPreview" class="text-center mb-4">
                                <div class="d-inline-block p-3 border rounded me-3">
                                    <div id="previewIcon" class="d-inline-block" style="width: 64px; height: 64px; background: #0153C8; color: white; display: flex; align-items: center; justify-content: center; font-size: 32px; font-weight: bold; border-radius: 8px;">A</div>
                                    <br><small class="text-muted">64x64 Preview</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Generated Favicons</h4>
                            <div id="faviconResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Favicon Generation: Creating Perfect Website Icons</h2>

                        <p>Favicons are small icons that represent websites in browser tabs, bookmarks, and shortcuts. This comprehensive guide explores favicon creation, standards, and best practices for modern web development and branding.</p>

                        <h3>What is a Favicon?</h3>

                        <p>A favicon (short for "favorite icon") is a small icon associated with a website that appears in browser tabs, bookmarks, browser history, and shortcut icons on desktop and mobile devices. Favicons help users identify and navigate between different websites easily.</p>

                        <h4>Favicon History</h4>

                        <p>Favicons were introduced by Internet Explorer 5 in 1999. Initially limited to 16x16 pixel ICO files, modern favicons now support multiple sizes and formats for different devices and contexts.</p>

                        <h3>Favicon Standards and Formats</h3>

                        <h4>Traditional ICO Format</h4>

                        <p>The original favicon format containing multiple icon sizes in a single file:</p>

                        <ul>
                            <li>16x16 pixels (browser tabs)</li>
                            <li>32x32 pixels (taskbar/desktop shortcuts)</li>
                            <li>48x48 pixels (Windows explorer)</li>
                        </ul>

                        <h4>Modern PNG Format</h4>

                        <p>PNG favicons offer better quality and transparency:</p>

                        <ul>
                            <li>16x16, 32x32, 48x64 pixels</li>
                            <li>Full alpha transparency</li>
                            <li>Smaller file sizes</li>
                            <li>Better compression</li>
                        </ul>

                        <h4>Apple Touch Icons</h4>

                        <p>Special icons for iOS devices and web app manifests:</p>

                        <ul>
                            <li>180x180 pixels (iPhone/iPad)</li>
                            <li>192x192 pixels (Android Chrome)</li>
                            <li>512x512 pixels (web app icons)</li>
                        </ul>

                        <h4>SVG Favicons</h4>

                        <p>Scalable vector favicons for future-proof design:</p>

                        <ul>
                            <li>Infinitely scalable</li>
                            <li>Small file sizes</li>
                            <li>Perfect for high-DPI displays</li>
                            <li>Modern browser support</li>
                        </ul>

                        <h3>Favicon Implementation</h3>

                        <h4>HTML Link Tags</h4>

                        <p>Standard way to add favicons to websites:</p>

                        <pre><code><link rel="icon" href="/favicon.ico" sizes="any">
<link rel="icon" href="/favicon.svg" type="image/svg+xml">
<link rel="apple-touch-icon" href="/apple-touch-icon.png"></code></pre>

                        <h4>Web App Manifest</h4>

                        <p>Modern approach for progressive web apps:</p>

                        <pre><code>{
  "name": "My App",
  "icons": [
    {
      "src": "/icon-192.png",
      "sizes": "192x192",
      "type": "image/png"
    }
  ]
}</code></pre>

                        <h3>Favicon Design Best Practices</h3>

                        <h4>Design Principles</h4>

                        <p>Creating effective favicons requires attention to detail:</p>

                        <ul>
                            <li><strong>Simplicity:</strong> Keep designs clean and recognizable at small sizes</li>
                            <li><strong>Contrast:</strong> Ensure good visibility against various backgrounds</li>
                            <li><strong>Brand Consistency:</strong> Match website logo and branding</li>
                            <li><strong>Scalability:</strong> Design should work at multiple sizes</li>
                        </ul>

                        <h4>Technical Requirements</h4>

                        <p>Favicons must meet technical specifications:</p>

                        <ul>
                            <li><strong>Square Format:</strong> All favicons should be square</li>
                            <li><strong>Transparent Background:</strong> PNG format with alpha channel</li>
                            <li><strong>High Resolution:</strong> Start with 512x512 pixels for best quality</li>
                            <li><strong>Color Limitations:</strong> Consider monochrome versions</li>
                        </ul>

                        <h3>Favicon Creation Methods</h3>

                        <h4>From Existing Images</h4>

                        <p>Converting logos and images to favicons:</p>

                        <ul>
                            <li>Start with high-resolution source (512x512+)</li>
                            <li>Use proper aspect ratio and cropping</li>
                            <li>Maintain brand colors and style</li>
                            <li>Test at various sizes</li>
                        </ul>

                        <h4>Text-Based Favicons</h4>

                        <p>Creating favicons from text or initials:</p>

                        <ul>
                            <li>Choose readable fonts</li>
                            <li>Use brand colors</li>
                            <li>Ensure good contrast</li>
                            <li>Keep text minimal (1-2 characters)</li>
                        </ul>

                        <h4>Emoji Favicons</h4>

                        <p>Using emoji characters as favicons:</p>

                        <ul>
                            <li>Select universally supported emojis</li>
                            <li>Ensure good visibility at small sizes</li>
                            <li>Match brand personality</li>
                            <li>Test across different platforms</li>
                        </ul>

                        <h3>Favicon Tools and Generators</h3>

                        <p>Various tools help create favicons:</p>

                        <ul>
                            <li><strong>RealFaviconGenerator:</strong> Comprehensive favicon generation</li>
                            <li><strong>Favicon.io:</strong> Simple text and emoji favicons</li>
                            <li><strong>Favicons Generator:</strong> Bulk favicon creation</li>
                            <li><strong>Online Favicon Generators:</strong> Web-based tools</li>
                        </ul>

                        <h3>Browser Compatibility</h3>

                        <h4>Modern Browsers</h4>

                        <p>All modern browsers support PNG and SVG favicons:</p>

                        <ul>
                            <li>Chrome 4+ (PNG, SVG)</li>
                            <li>Firefox 41+ (PNG, SVG)</li>
                            <li>Safari 12+ (PNG, SVG)</li>
                            <li>Edge 12+ (PNG, ICO)</li>
                        </ul>

                        <h4>Legacy Support</h4>

                        <p>Maintaining compatibility with older browsers:</p>

                        <ul>
                            <li>ICO format for older IE versions</li>
                            <li>Multiple sizes for different contexts</li>
                            <li>Fallback to default favicon.ico</li>
                        </ul>

                        <h3>Favicon SEO Benefits</h3>

                        <h4>Brand Recognition</h4>

                        <p>Favicons enhance brand visibility:</p>

                        <ul>
                            <li>Increased brand recognition in browser tabs</li>
                            <li>Better user experience and navigation</li>
                            <li>Professional appearance in bookmarks</li>
                            <li>Improved brand consistency</li>
                        </ul>

                        <h4>User Experience</h4>

                        <p>Favicons improve usability:</p>

                        <ul>
                            <li>Easier website identification</li>
                            <li>Faster navigation between tabs</li>
                            <li>Better bookmark organization</li>
                            <li>Enhanced mobile experience</li>
                        </ul>

                        <h3>Common Favicon Issues</h3>

                        <h4>Display Problems</h4>

                        <p>Common favicon display issues:</p>

                        <ul>
                            <li>Not showing in browser tabs</li>
                            <li>Wrong size or format</li>
                            <li>Caching issues</li>
                            <li>Server configuration problems</li>
                        </ul>

                        <h4>Technical Issues</h4>

                        <p>Technical implementation problems:</p>

                        <ul>
                            <li>Incorrect file paths</li>
                            <li>Missing MIME types</li>
                            <li>Server not serving favicon files</li>
                            <li>CDN caching issues</li>
                        </ul>

                        <h3>Favicon Testing and Validation</h3>

                        <h4>Testing Tools</h4>

                        <p>Tools to test favicon implementation:</p>

                        <ul>
                            <li><strong>Favicon Checker:</strong> Validate favicon setup</li>
                            <li><strong>Browser DevTools:</strong> Inspect favicon loading</li>
                            <li><strong>RealFaviconGenerator:</strong> Test favicon display</li>
                        </ul>

                        <h4>Cross-Platform Testing</h4>

                        <p>Testing favicons across different platforms:</p>

                        <ul>
                            <li>Desktop browsers (Chrome, Firefox, Safari, Edge)</li>
                            <li>Mobile browsers (iOS Safari, Chrome Mobile)</li>
                            <li>Desktop shortcuts and bookmarks</li>
                            <li>Progressive web app icons</li>
                        </ul>

                        <h3>Advanced Favicon Techniques</h3>

                        <h4>Dynamic Favicons</h4>

                        <p>Changing favicons based on page state:</p>

                        <ul>
                            <li>Notification indicators</li>
                            <li>Loading states</li>
                            <li>Status updates</li>
                            <li>Real-time information display</li>
                        </ul>

                        <h4>Themed Favicons</h4>

                        <p>Different favicons for light/dark themes:</p>

                        <ul>
                            <li>Automatic theme detection</li>
                            <li>Manual theme switching</li>
                            <li>System preference integration</li>
                        </ul>

                        <h3>Favicon Performance</h3>

                        <h4>Optimization Techniques</h4>

                        <p>Optimizing favicon loading and performance:</p>

                        <ul>
                            <li>Compress PNG files</li>
                            <li>Use appropriate caching headers</li>
                            <li>Minimize HTTP requests</li>
                            <li>Preload critical favicons</li>
                        </ul>

                        <h4>Loading Priority</h4>

                        <p>Favicon loading best practices:</p>

                        <ul>
                            <li>Place favicon links in <head></li>
                            <li>Use preload hints for critical favicons</li>
                            <li>Implement proper caching strategies</li>
                        </ul>

                        <h3>Future of Favicons</h3>

                        <p>Favicon technology continues to evolve:</p>

                        <ul>
                            <li><strong>SVG Favicons:</strong> Becoming the standard for scalable icons</li>
                            <li><strong>Web App Manifests:</strong> Advanced icon specifications</li>
                            <li><strong>Dynamic Favicons:</strong> Interactive and animated icons</li>
                            <li><strong>AI-Generated:</strong> Automated favicon creation</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Favicons are essential elements of modern web design that enhance brand recognition and user experience. Understanding favicon standards, creating effective designs, and implementing proper technical specifications will help create professional and recognizable website icons.</p>

                        <p>Regular testing, optimization, and staying updated with evolving standards will ensure favicons display correctly across all devices and browsers. A well-designed favicon contributes significantly to overall brand perception and user experience.</p>

                        <p>Combine favicon generation with our <a href="<?php echo $base_url; ?>/tools/image-alt-checker">image alt checker</a> and <a href="<?php echo $base_url; ?>/tools/responsive-checker">responsive checker</a> for complete website optimization.</p>

                        <p>For more information about favicons and web standards, check the <a href="https://html.spec.whatwg.org/multipage/links.html#rel-icon" target="_blank" rel="noopener">HTML specification for link types</a> and <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Link_types" target="_blank" rel="noopener">MDN Web Docs</a>. Start creating professional favicons today and enhance your website's visual identity.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🖼️</div>
                        <h4>Image Alt Checker</h4>
                        <p>Check and optimize alt text for images to improve SEO and accessibility.</p>
                        <a href="<?php echo $base_url; ?>/tools/image-alt-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📱</div>
                        <h4>Responsive Checker</h4>
                        <p>Test website responsiveness across different devices and screen sizes.</p>
                        <a href="<?php echo $base_url; ?>/tools/responsive-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🎨</div>
                        <h4>CSS Validation Tool</h4>
                        <p>Validate CSS code and check for syntax errors and best practices.</p>
                        <a href="<?php echo $base_url; ?>/tools/css-validation-tool" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        // Handle source type changes
        document.querySelectorAll('input[name="sourceType"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const sourceType = this.value;
                document.getElementById('imageUploadSection').style.display = sourceType === 'image' ? 'block' : 'none';
                document.getElementById('textInputSection').style.display = sourceType === 'text' ? 'block' : 'none';
                document.getElementById('urlInputSection').style.display = sourceType === 'url' ? 'block' : 'none';
                updatePreview();
            });
        });

        // Update preview in real-time
        document.getElementById('faviconText').addEventListener('input', updatePreview);
        document.getElementById('bgColor').addEventListener('input', updatePreview);
        document.getElementById('textColor').addEventListener('input', updatePreview);

        function updatePreview() {
            const sourceType = document.querySelector('input[name="sourceType"]:checked').value;
            const previewIcon = document.getElementById('previewIcon');
            const bgColor = document.getElementById('bgColor').value;
            const textColor = document.getElementById('textColor').value;

            previewIcon.style.background = bgColor;
            previewIcon.style.color = textColor;

            if (sourceType === 'text') {
                const text = document.getElementById('faviconText').value || 'A';
                previewIcon.textContent = text;
                previewIcon.style.fontSize = text.length === 1 ? '32px' : '24px';
            } else {
                previewIcon.textContent = '★'; // Placeholder for image
            }

            document.getElementById('previewSection').style.display = 'block';
        }

        document.getElementById('faviconGeneratorForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const sourceType = document.querySelector('input[name="sourceType"]:checked').value;
            const resultsDiv = document.getElementById('faviconResults');

            // Basic validation
            if (sourceType === 'image' && !document.getElementById('imageFile').files[0]) {
                alert('Please select an image file to upload.');
                return;
            }
            if (sourceType === 'text' && !document.getElementById('faviconText').value.trim()) {
                alert('Please enter text or emoji for the favicon.');
                return;
            }
            if (sourceType === 'url' && !document.getElementById('imageUrl').value.trim()) {
                alert('Please enter a valid image URL.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Generating favicons...</p></div>';

            // In a real implementation, this would generate actual favicons
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Favicon Generation Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Generation Summary</h5>
                            <div class="alert alert-info">
                                <strong>Source Type:</strong> ${sourceType.charAt(0).toUpperCase() + sourceType.slice(1)}<br>
                                <strong>Formats Generated:</strong> ${getSelectedFormats().join(', ')}<br>
                                <strong>Total Files:</strong> ${getSelectedFormats().length * 4}<br>
                                <strong>Processing Time:</strong> 2.3 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Quality Check</h5>
                            <div class="alert alert-success">
                                <strong>Resolution:</strong> High quality<br>
                                <strong>Transparency:</strong> Supported<br>
                                <strong>Compatibility:</strong> All browsers<br>
                                <strong>Optimization:</strong> Compressed
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Generated Favicon Files</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Standard Sizes</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>favicon-16x16.png</strong>
                                            <br><small class="text-muted">Browser tabs, bookmarks</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>favicon-32x32.png</strong>
                                            <br><small class="text-muted">Desktop shortcuts</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>favicon-48x48.png</strong>
                                            <br><small class="text-muted">Windows explorer</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>favicon.ico</strong>
                                            <br><small class="text-muted">Legacy browser support</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Apple & Modern</h6>
                                <div class="list-group">
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>apple-touch-icon.png</strong>
                                            <br><small class="text-muted">iOS home screen</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>icon-192.png</strong>
                                            <br><small class="text-muted">Android Chrome</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>icon-512.png</strong>
                                            <br><small class="text-muted">PWA install</small>
                                        </div>
                                        <span class="badge bg-success">✓</span>
                                    </div>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong>favicon.svg</strong>
                                            <br><small class="text-muted">Scalable vector</small>
                                        </div>
                                        <span class="badge bg-info">Optional</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>HTML Implementation Code</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="mb-0">Copy this code to your <head> section</h6>
                                    <button class="btn btn-sm btn-outline-primary" onclick="copyHtmlCode()">Copy Code</button>
                                </div>
                                <div id="htmlCode" class="bg-dark text-light p-3 rounded">
                                    <pre class="mb-0 text-white"><code><!-- Favicon -->
<link rel="icon" type="image/x-icon" href="/favicon.ico">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="48x48" href="/favicon-48x48.png">

<!-- Apple Touch Icon -->
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">

<!-- Android/Chrome -->
<link rel="icon" type="image/png" sizes="192x192" href="/icon-192.png">
<link rel="icon" type="image/png" sizes="512x512" href="/icon-512.png">

<!-- Safari Pinned Tab -->
<link rel="mask-icon" href="/favicon.svg" color="#0153C8"></code></pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Download Options</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="downloadZip()">
                                Download All Files (ZIP)
                            </button>
                            <button class="btn btn-outline-primary" onclick="downloadIco()">
                                Download ICO Only
                            </button>
                            <button class="btn btn-outline-primary" onclick="previewInBrowser()">
                                Preview in Browser
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Browser Compatibility</h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Chrome</h6>
                                        <h4 class="text-success">100%</h4>
                                        <small>Full support</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Firefox</h6>
                                        <h4 class="text-success">100%</h4>
                                        <small>Full support</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Safari</h6>
                                        <h4 class="text-success">100%</h4>
                                        <small>Full support</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Edge</h6>
                                        <h4 class="text-success">100%</h4>
                                        <small>Full support</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Analysis & Recommendations</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ All favicon sizes generated successfully</li>
                            <li class="list-group-item list-group-item-success">✓ Cross-browser compatibility ensured</li>
                            <li class="list-group-item list-group-item-info">ℹ HTML code generated for easy implementation</li>
                            <li class="list-group-item list-group-item-info">ℹ Files optimized for web performance</li>
                            <li class="list-group-item list-group-item-success">✓ Ready for immediate website deployment</li>
                        </ul>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2500);
        });

        function getSelectedFormats() {
            const formats = [];
            if (document.getElementById('formatIco').checked) formats.push('ICO');
            if (document.getElementById('formatPng').checked) formats.push('PNG');
            if (document.getElementById('formatApple').checked) formats.push('Apple');
            if (document.getElementById('formatSvg').checked) formats.push('SVG');
            return formats;
        }

        function copyHtmlCode() {
            const code = document.getElementById('htmlCode').textContent;
            navigator.clipboard.writeText(code).then(() => {
                alert('HTML code copied to clipboard!');
            });
        }

        function downloadZip() {
            alert('Downloading favicon package (ZIP file)...\n\nThis would contain all generated favicon files in a real implementation.');
        }

        function downloadIco() {
            alert('Downloading favicon.ico file...\n\nThis would download the ICO file in a real implementation.');
        }

        function previewInBrowser() {
            const newTab = window.open('about:blank', '_blank');
            newTab.document.write(`
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Favicon Preview</title>
                    <link rel="icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>⭐</text></svg>">
                </head>
                <body>
                    <h1>Favicon Preview</h1>
                    <p>Check the browser tab to see your favicon!</p>
                    <p><strong>Note:</strong> This is a demo preview. In a real implementation, this would show your actual generated favicon.</p>
                </body>
                </html>
            `);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('previewSection').style.display = 'none';
            document.getElementById('faviconText').value = '';
            document.getElementById('imageFile').value = '';
            document.getElementById('imageUrl').value = '';
        }

        // Initialize preview
        updatePreview();
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>