<?php
$page_title = "Email Extractor - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Email Extractor",
        "description": "Extract email addresses from text, websites, and documents for contact management and lead generation.",
        "url": "<?php echo $base_url; ?>/tools/email-extractor",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Email address extraction from text",
            "Format validation and verification",
            "Duplicate removal and cleaning",
            "Contact management and export",
            "Bulk processing capabilities"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Email Extractor</h1>
                    <p class="fade-in">Extract email addresses from text, websites, and documents for contact management and lead generation.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Extract Email Addresses</h3>
                        <form id="emailExtractorForm">
                            <div class="mb-3">
                                <label for="inputText" class="form-label">Text to Analyze</label>
                                <textarea class="form-control" id="inputText" rows="6" placeholder="Paste your text, website content, or document here to extract email addresses..." required></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="extractionType" class="form-label">Extraction Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="removeDuplicates" checked>
                                            <label class="form-check-label" for="removeDuplicates">
                                                Remove duplicate emails
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="validateEmails" checked>
                                            <label class="form-check-label" for="validateEmails">
                                                Validate email formats
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="sortEmails" checked>
                                            <label class="form-check-label" for="sortEmails">
                                                Sort emails alphabetically
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="excludeCommon" checked>
                                            <label class="form-check-label" for="excludeCommon">
                                                Exclude common spam emails
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Extract Emails</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Email Extraction Results</h4>
                            <div id="emailResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Email Extraction for Contact Management and Lead Generation</h2>

                        <p>Email extraction is essential for businesses and marketers who need to collect contact information from various sources. An email extractor helps identify and collect email addresses from text, websites, documents, and other content sources for contact management, lead generation, and communication purposes. This comprehensive guide explores email extraction techniques, best practices, and legal considerations.</p>

                        <h3>What is Email Extraction?</h3>

                        <p>Email extraction involves using algorithms and patterns to identify and collect email addresses from unstructured text data. This process helps businesses build contact lists, validate communications, and manage customer relationships effectively.</p>

                        <h4>Common Use Cases</h4>

                        <ul>
                            <li><strong>Lead Generation:</strong> Collecting potential customer emails</li>
                            <li><strong>Contact Management:</strong> Building and organizing contact databases</li>
                            <li><strong>Data Migration:</strong> Extracting emails from legacy systems</li>
                            <li><strong>Content Analysis:</strong> Finding contact information in documents</li>
                            <li><strong>Marketing Campaigns:</strong> Building targeted email lists</li>
                        </ul>

                        <h3>How Email Extractors Work</h3>

                        <p>Email extraction tools use sophisticated pattern matching and validation:</p>

                        <ol>
                            <li><strong>Text Parsing:</strong> Analyze input text for email patterns</li>
                            <li><strong>Pattern Recognition:</strong> Identify valid email address formats</li>
                            <li><strong>Validation:</strong> Verify email syntax and structure</li>
                            <li><strong>Filtering:</strong> Remove duplicates and invalid addresses</li>
                            <li><strong>Organization:</strong> Sort and categorize extracted emails</li>
                        </ol>

                        <h3>Email Address Formats and Patterns</h3>

                        <h4>Standard Email Format</h4>

                        <p>Email addresses follow the pattern: local-part@domain</p>

                        <pre><code>Valid formats:
user@example.com
firstname.lastname@company.org
user+tag@gmail.com
test.email@subdomain.example.co.uk</code></pre>

                        <h4>Complex Email Patterns</h4>

                        <ul>
                            <li><strong>Plus Addressing:</strong> user+tag@example.com</li>
                            <li><strong>Subdomains:</strong> user@mail.subdomain.com</li>
                            <li><strong>International Domains:</strong> user@example.中国</li>
                            <li><strong>IP Addresses:</strong> user@[192.168.1.1]</li>
                        </ul>

                        <h3>Email Extraction Best Practices</h3>

                        <h4>Quality Over Quantity</h4>

                        <p>Focus on extracting high-quality, valid email addresses:</p>

                        <ul>
                            <li>Validate email formats before extraction</li>
                            <li>Remove obviously fake or spam emails</li>
                            <li>Check for common typos and errors</li>
                            <li>Verify domain validity when possible</li>
                        </ul>

                        <h4>Data Privacy Compliance</h4>

                        <p>Ensure compliance with data protection regulations:</p>

                        <ul>
                            <li>Obtain consent for email collection</li>
                            <li>Respect opt-out requests</li>
                            <li>Follow GDPR and CAN-SPAM regulations</li>
                            <li>Provide clear privacy policies</li>
                        </ul>

                        <h3>Common Email Extraction Challenges</h3>

                        <h4>False Positives</h4>

                        <p>Avoid extracting invalid email-like strings:</p>

                        <pre><code>❌ Extracted: "Contact us at info@"
✅ Correct:   "Contact us at info@example.com"</code></pre>

                        <h4>Obfuscated Emails</h4>

                        <p>Handle emails hidden to prevent scraping:</p>

                        <pre><code>Hidden: info [at] example [dot] com
Should extract: info@example.com</code></pre>

                        <h4>International Characters</h4>

                        <p>Support Unicode characters in email addresses:</p>

                        <ul>
                            <li>Arabic, Chinese, and other Unicode domains</li>
                            <li>Internationalized Domain Names (IDN)</li>
                            <li>UTF-8 encoding support</li>
                        </ul>

                        <h3>Email Validation and Verification</h3>

                        <h4>Syntax Validation</h4>

                        <p>Check email format correctness:</p>

                        <ul>
                            <li>Proper @ symbol placement</li>
                            <li>Valid domain structure</li>
                            <li>Correct character usage</li>
                            <li>Length limitations</li>
                        </ul>

                        <h4>Domain Verification</h4>

                        <p>Verify domain existence and validity:</p>

                        <ul>
                            <li>DNS MX record checks</li>
                            <li>Domain registration status</li>
                            <li>Disposable email detection</li>
                            <li>Spam domain filtering</li>
                        </ul>

                        <h3>Email Extraction Tools and Techniques</h3>

                        <p>Various methods and tools for email extraction:</p>

                        <ul>
                            <li><strong>Regular Expressions:</strong> Pattern-based extraction</li>
                            <li><strong>Machine Learning:</strong> AI-powered email detection</li>
                            <li><strong>Web Scraping:</strong> Automated website crawling</li>
                            <li><strong>API Integration:</strong> Third-party validation services</li>
                        </ul>

                        <h3>Legal and Ethical Considerations</h3>

                        <h4>Data Protection Laws</h4>

                        <p>Comply with international privacy regulations:</p>

                        <ul>
                            <li><strong>GDPR:</strong> EU General Data Protection Regulation</li>
                            <li><strong>CAN-SPAM:</strong> US anti-spam legislation</li>
                            <li><strong>CASLA:</strong> Canadian anti-spam law</li>
                            <li><strong>PIPEDA:</strong> Personal Information Protection and Electronic Documents Act</li>
                        </ul>

                        <h4>Ethical Email Collection</h4>

                        <ul>
                            <li>Only collect emails with permission</li>
                            <li>Provide clear opt-out options</li>
                            <li>Be transparent about data usage</li>
                            <li>Respect do-not-contact lists</li>
                        </ul>

                        <h3>Email Extraction for Different Sources</h3>

                        <h4>Website Content</h4>

                        <p>Extract emails from web pages and blogs:</p>

                        <ul>
                            <li>Contact pages and about sections</li>
                            <li>Footer information and disclaimers</li>
                            <li>Team member profiles</li>
                            <li>Press releases and announcements</li>
                        </ul>

                        <h4>Documents and Files</h4>

                        <p>Extract from various document formats:</p>

                        <ul>
                            <li>PDF documents and reports</li>
                            <li>Word documents and spreadsheets</li>
                            <li>Text files and CSV data</li>
                            <li>Email archives and backups</li>
                        </ul>

                        <h4>Social Media and Forums</h4>

                        <p>Collect emails from social platforms:</p>

                        <ul>
                            <li>User profiles and bios</li>
                            <li>Forum signatures and posts</li>
                            <li>Business pages and listings</li>
                            <li>Comment sections and reviews</li>
                        </ul>

                        <h3>Email List Management</h3>

                        <h4>Deduplication</h4>

                        <p>Remove duplicate email addresses:</p>

                        <ul>
                            <li>Case-insensitive matching</li>
                            <li>Domain normalization</li>
                            <li>Typo correction</li>
                            <li>Plus addressing handling</li>
                        </ul>

                        <h4>Segmentation</h4>

                        <p>Organize emails by categories:</p>

                        <ul>
                            <li>Domain-based grouping</li>
                            <li>Geographic segmentation</li>
                            <li>Industry categorization</li>
                            <li>Engagement scoring</li>
                        </ul>

                        <h3>Email Extraction APIs and Services</h3>

                        <p>Third-party services for email extraction:</p>

                        <ul>
                            <li><strong>Validation Services:</strong> NeverBounce, Mailgun</li>
                            <li><strong>Extraction APIs:</strong> Hunter.io, Clearbit</li>
                            <li><strong>CRM Integration:</strong> Salesforce, HubSpot</li>
                            <li><strong>Marketing Tools:</strong> Mailchimp, Constant Contact</li>
                        </ul>

                        <h3>Measuring Email Quality</h3>

                        <p>Assess the quality of extracted email lists:</p>

                        <ul>
                            <li><strong>Deliverability Rate:</strong> Percentage of emails that reach inbox</li>
                            <li><strong>Open Rate:</strong> Email engagement metrics</li>
                            <li><strong>Bounce Rate:</strong> Invalid email percentage</li>
                            <li><strong>Spam Complaints:</strong> Unsubscribe and spam reports</li>
                        </ul>

                        <h3>Advanced Email Extraction Techniques</h3>

                        <h4>Machine Learning Approaches</h4>

                        <p>Use AI for intelligent email detection:</p>

                        <ul>
                            <li>Natural language processing</li>
                            <li>Context-aware extraction</li>
                            <li>Pattern recognition</li>
                            <li>Anomaly detection</li>
                        </ul>

                        <h4>Real-time Extraction</h4>

                        <p>Extract emails from live web content:</p>

                        <ul>
                            <li>Web crawling and scraping</li>
                            <li>API data processing</li>
                            <li>Stream processing</li>
                            <li>Real-time validation</li>
                        </ul>

                        <h3>Email Extraction Best Practices</h3>

                        <h4>Data Quality Assurance</h4>

                        <ul>
                            <li>Regular validation and cleaning</li>
                            <li>Monitor bounce rates and complaints</li>
                            <li>Update contact information</li>
                            <li>Respect unsubscribe requests</li>
                        </ul>

                        <h4>Performance Optimization</h4>

                        <ul>
                            <li>Use efficient extraction algorithms</li>
                            <li>Implement caching for repeated extractions</li>
                            <li>Batch processing for large datasets</li>
                            <li>Parallel processing capabilities</li>
                        </ul>

                        <h3>Future of Email Extraction</h3>

                        <p>Email extraction technology continues to evolve:</p>

                        <ul>
                            <li><strong>AI-Powered Extraction:</strong> Machine learning for better accuracy</li>
                            <li><strong>Real-time Validation:</strong> Instant email verification</li>
                            <li><strong>Privacy-First Tools:</strong> Consent-aware extraction</li>
                            <li><strong>Blockchain Verification:</strong> Decentralized email validation</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Email extraction is a powerful tool for businesses looking to build contact lists and manage customer relationships. An email extractor helps identify and collect email addresses from various sources while ensuring data quality and compliance with privacy regulations. By following best practices and using proper validation techniques, you can build high-quality email lists that drive successful marketing campaigns.</p>

                        <p>Remember that email extraction should always be done ethically and in compliance with data protection laws. Focus on quality over quantity, and always respect user privacy and consent preferences.</p>

                        <p>Combine email extraction with other contact management tools like our <a href="<?php echo $base_url; ?>/tools/phone-number-extractor">phone number extractor</a> and <a href="<?php echo $base_url; ?>/tools/text-analyzer">text analyzer</a> for comprehensive contact data management.</p>

                        <p>For more information on email validation and extraction, check the <a href="https://tools.ietf.org/html/rfc5322" target="_blank" rel="noopener">RFC 5322 email specification</a> and <a href="https://www.gdpr.eu/what-is-gdpr/" target="_blank" rel="noopener">GDPR guidelines</a>. Start extracting emails responsibly today and build better customer relationships.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📞</div>
                        <h4>Phone Number Extractor</h4>
                        <p>Extract and validate phone numbers from text and documents.</p>
                        <a href="<?php echo $base_url; ?>/tools/phone-number-extractor" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📝</div>
                        <h4>Text Analyzer</h4>
                        <p>Analyze text content for readability, sentiment, and SEO metrics.</p>
                        <a href="<?php echo $base_url; ?>/tools/text-analyzer" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>Keyword Research Tool</h4>
                        <p>Discover high-value keywords for your content and SEO strategy.</p>
                        <a href="<?php echo $base_url; ?>/tools/keyword-research" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('emailExtractorForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const inputText = document.getElementById('inputText').value;
            const removeDuplicates = document.getElementById('removeDuplicates').checked;
            const validateEmails = document.getElementById('validateEmails').checked;
            const sortEmails = document.getElementById('sortEmails').checked;
            const excludeCommon = document.getElementById('excludeCommon').checked;
            const resultsDiv = document.getElementById('emailResults');

            if (!inputText.trim()) {
                alert('Please enter text to extract emails from.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Extracting email addresses...</p></div>';

            // In a real implementation, this would extract emails from the text
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                // Simulate email extraction
                const extractedEmails = extractEmailsFromText(inputText);
                let processedEmails = [...extractedEmails];

                // Apply filters
                if (removeDuplicates) {
                    processedEmails = removeDuplicateEmails(processedEmails);
                }

                if (validateEmails) {
                    processedEmails = validateEmailAddresses(processedEmails);
                }

                if (excludeCommon) {
                    processedEmails = excludeCommonSpamEmails(processedEmails);
                }

                if (sortEmails) {
                    processedEmails = processedEmails.sort();
                }

                const mockResults = `
                    <div class="alert alert-${processedEmails.length > 0 ? 'success' : 'warning'}">
                        <strong>${processedEmails.length > 0 ? '✓' : '⚠'} Email Extraction ${processedEmails.length > 0 ? 'Successful' : 'No emails found'}</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Extraction Summary</h5>
                            <div class="alert alert-info">
                                <strong>Original Text Length:</strong> ${inputText.length} characters<br>
                                <strong>Emails Found:</strong> ${extractedEmails.length}<br>
                                <strong>Valid Emails:</strong> ${processedEmails.length}<br>
                                <strong>Duplicates Removed:</strong> ${removeDuplicates ? extractedEmails.length - new Set(extractedEmails.map(e => e.toLowerCase())).size : 0}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Processing Options</h5>
                            <div class="alert alert-success">
                                <strong>Duplicates Removed:</strong> ${removeDuplicates ? 'Yes' : 'No'}<br>
                                <strong>Validation Applied:</strong> ${validateEmails ? 'Yes' : 'No'}<br>
                                <strong>Sorted Alphabetically:</strong> ${sortEmails ? 'Yes' : 'No'}<br>
                                <strong>Spam Filtered:</strong> ${excludeCommon ? 'Yes' : 'No'}
                            </div>
                        </div>
                    </div>
                    ${processedEmails.length > 0 ? `
                    <div class="mt-4">
                        <h5>Extracted Email Addresses</h5>
                        <div class="bg-light p-3 rounded" style="max-height: 300px; overflow-y: auto;">
                            <div class="row">
                                ${processedEmails.map((email, index) => `
                                    <div class="col-md-6 mb-2">
                                        <div class="d-flex align-items-center">
                                            <span class="badge bg-primary me-2">${index + 1}</span>
                                            <code class="flex-grow-1">${email}</code>
                                            <button class="btn btn-sm btn-outline-secondary ms-2" onclick="copySingleEmail('${email}')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                `).join('')}
                            </div>
                        </div>
                        <div class="mt-2">
                            <button class="btn btn-sm btn-outline-primary" onclick="copyAllEmails('${processedEmails.join('\\n')}')">
                                Copy All Emails
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" onclick="downloadEmails('${processedEmails.join('\\n')}')">
                                Download as CSV
                            </button>
                        </div>
                    </div>
                    ` : ''}
                    <div class="mt-4">
                        <h5>Email Quality Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Domain Distribution</h6>
                                <div class="bg-light p-3 rounded" style="max-height: 200px; overflow-y: auto;">
                                    ${generateDomainStats(processedEmails)}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h6>Validation Results</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Valid Format
                                        <span class="badge bg-success">${processedEmails.length}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Common Domains
                                        <span class="badge bg-info">${countCommonDomains(processedEmails)}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Unique Domains
                                        <span class="badge bg-primary">${new Set(processedEmails.map(e => e.split('@')[1])).size}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        Gmail Addresses
                                        <span class="badge bg-warning">${processedEmails.filter(e => e.includes('@gmail.com')).length}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Usage Recommendations</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-info">ℹ Use these emails responsibly and in compliance with privacy laws</li>
                            <li class="list-group-item list-group-item-info">ℹ Consider implementing double opt-in for marketing emails</li>
                            <li class="list-group-item list-group-item-success">✓ All extracted emails have been validated for proper format</li>
                            <li class="list-group-item list-group-item-warning">⚠ Always respect unsubscribe requests and privacy preferences</li>
                            <li class="list-group-item list-group-item-info">ℹ Consider segmenting emails by domain for targeted campaigns</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Export Options</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="exportAsCSV('${processedEmails.join(',')}')">
                                Export as CSV
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportAsJSON('${JSON.stringify(processedEmails).replace(/'/g, "\\'")}')">
                                Export as JSON
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportAsTXT('${processedEmails.join('\\n')}')">
                                Export as Text File
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 1500);
        });

        function extractEmailsFromText(text) {
            // Simple email extraction regex - in production, use more sophisticated patterns
            const emailRegex = /[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/g;
            const matches = text.match(emailRegex);
            return matches || [];
        }

        function removeDuplicateEmails(emails) {
            return [...new Set(emails.map(email => email.toLowerCase()))].map(email =>
                emails.find(e => e.toLowerCase() === email)
            );
        }

        function validateEmailAddresses(emails) {
            // Basic email validation
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emails.filter(email => emailRegex.test(email));
        }

        function excludeCommonSpamEmails(emails) {
            const spamDomains = ['10minutemail.com', 'guerrillamail.com', 'mailinator.com', 'temp-mail.org'];
            return emails.filter(email => {
                const domain = email.split('@')[1];
                return !spamDomains.includes(domain);
            });
        }

        function generateDomainStats(emails) {
            const domainCount = {};
            emails.forEach(email => {
                const domain = email.split('@')[1];
                domainCount[domain] = (domainCount[domain] || 0) + 1;
            });

            const sortedDomains = Object.entries(domainCount)
                .sort(([,a], [,b]) => b - a)
                .slice(0, 10);

            return sortedDomains.map(([domain, count]) =>
                `<div class="d-flex justify-content-between"><span>${domain}</span><span class="badge bg-secondary">${count}</span></div>`
            ).join('');
        }

        function countCommonDomains(emails) {
            const commonDomains = ['gmail.com', 'yahoo.com', 'hotmail.com', 'outlook.com'];
            return emails.filter(email => {
                const domain = email.split('@')[1];
                return commonDomains.includes(domain);
            }).length;
        }

        function copySingleEmail(email) {
            navigator.clipboard.writeText(email).then(() => {
                // Show temporary feedback
                const button = event.target.closest('button');
                const originalHTML = button.innerHTML;
                button.innerHTML = '<i class="fas fa-check"></i>';
                button.classList.remove('btn-outline-secondary');
                button.classList.add('btn-success');

                setTimeout(() => {
                    button.innerHTML = originalHTML;
                    button.classList.remove('btn-success');
                    button.classList.add('btn-outline-secondary');
                }, 1000);
            });
        }

        function copyAllEmails(emailsText) {
            navigator.clipboard.writeText(emailsText).then(() => {
                alert('All emails copied to clipboard!');
            });
        }

        function downloadEmails(emailsText) {
            const blob = new Blob([emailsText], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'extracted-emails.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function exportAsCSV(emails) {
            const csvContent = 'Email Address\n' + emails.split(',').join('\n');
            const blob = new Blob([csvContent], { type: 'text/csv' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'extracted-emails.csv';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function exportAsJSON(emailsJSON) {
            const jsonContent = JSON.stringify(JSON.parse(emailsJSON), null, 2);
            const blob = new Blob([jsonContent], { type: 'application/json' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'extracted-emails.json';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function exportAsTXT(emailsText) {
            const blob = new Blob([emailsText], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'extracted-emails.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('inputText').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>